/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service;

import co.uk.automationconsultants.compliance.json.level.LevelJson;
import co.uk.automationconsultants.compliance.json.statistics.SpaceStatistics;
import co.uk.automationconsultants.compliance.json.statistics.StatisticsJson;
import co.uk.automationconsultants.compliance.service.ClassificationService;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.Range;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.DoubleRangeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="statisticsService")
public class StatisticsService {
    @ComponentImport
    private final SearchManager searchManager;
    @ComponentImport
    private final SpaceService spaceService;
    private final ClassificationService classificationService;
    private static final Logger log = LoggerFactory.getLogger(StatisticsService.class);

    public StatisticsService(SearchManager searchManager, SpaceService spaceService, ClassificationService classificationService) {
        this.searchManager = searchManager;
        this.spaceService = spaceService;
        this.classificationService = classificationService;
    }

    private int getClassificationCount(int index, String spaceKey) throws InvalidSearchException, ReflectiveOperationException {
        ContentSearch contentSearch = this.initContentSearch(BooleanQuery.andQuery((SearchQuery[])new SearchQuery[]{new ContentTypeQuery(ContentTypeEnum.PAGE), new InSpaceQuery(spaceKey), this.getQuery(index)}), null);
        return this.getCount((ISearch)contentSearch);
    }

    private int getCount(ISearch search) throws InvalidSearchException, IllegalArgumentException {
        return this.searchManager.search(search).getUnfilteredResultsCount();
    }

    private SearchQuery getQuery(double i) {
        return new DoubleRangeQuery("content-property-classification-name.index", new Range((Object)i, (Object)(i + 1.0), true, false));
    }

    private SearchQuery getPendingQuery(List<LevelJson> levels, String spaceKey) {
        return new BooleanQuery(new ArrayList<SearchQuery>(Arrays.asList(new InSpaceQuery(spaceKey), new ContentTypeQuery(ContentTypeEnum.PAGE))), Collections.emptyList(), (Collection)IntStream.range(0, levels.size()).mapToObj(this::getQuery).collect(Collectors.toList()));
    }

    private int getPendingClassificationCount(List<LevelJson> levels, String spaceKey) throws InvalidSearchException, ReflectiveOperationException {
        ContentSearch contentSearch = this.initContentSearch(this.getPendingQuery(levels, spaceKey), null);
        return this.getCount((ISearch)contentSearch);
    }

    private StatisticsJson getStatisticsImpl(String spaceKey, String spaceTitle, List<LevelJson> levels) {
        ArrayList<SpaceStatistics> spaceStatisticsList = new ArrayList<SpaceStatistics>();
        for (int index = 0; index < levels.size(); ++index) {
            LevelJson level = levels.get(index);
            SpaceStatistics spaceStatistics = null;
            try {
                spaceStatistics = new SpaceStatistics(level.getName(), this.getClassificationCount(index, spaceKey));
                spaceStatisticsList.add(spaceStatistics);
                continue;
            }
            catch (InvalidSearchException | IllegalArgumentException | ReflectiveOperationException e) {
                log.error("Failed to get statistics for Level {}. error: {}", (Object)level.getName(), (Object)e.getMessage());
            }
        }
        SpaceStatistics pendingStatistics = null;
        try {
            pendingStatistics = new SpaceStatistics("Pending Classification", this.getPendingClassificationCount(levels, spaceKey));
        }
        catch (InvalidSearchException | IllegalArgumentException | ReflectiveOperationException e) {
            log.error("Failed to get statistics for Pending Classification. error: {}", (Object)e.getMessage());
        }
        if (pendingStatistics != null) {
            spaceStatisticsList.add(pendingStatistics);
        }
        return new StatisticsJson(spaceKey, spaceTitle, spaceStatisticsList);
    }

    public StatisticsJson getStatistics(String spaceKey) {
        Space space = (Space)this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetchOrNull();
        return space == null ? null : this.getStatisticsImpl(space.getKey(), space.getName(), this.classificationService.getLevels());
    }

    public List<StatisticsJson> getAllStatistics() {
        int start = 0;
        int limit = 50;
        List<LevelJson> levels = this.classificationService.getLevels();
        ArrayList<StatisticsJson> allStatistics = new ArrayList<StatisticsJson>();
        boolean hasMore = true;
        while (hasMore) {
            PageResponse spacePageResponse = this.spaceService.find(new Expansion[0]).fetchMany((PageRequest)new SimplePageRequest(start, 50));
            List partialStatistics = spacePageResponse.getResults().stream().map(space -> this.getStatisticsImpl(space.getKey(), space.getName(), levels)).collect(Collectors.toList());
            allStatistics.addAll(partialStatistics);
            hasMore = spacePageResponse.hasMore();
            start += 50;
        }
        return allStatistics;
    }

    private ContentSearch initContentSearch(SearchQuery query, SearchSort sort) throws ReflectiveOperationException {
        try {
            Constructor ctr = ContentSearch.class.getConstructor(SearchQuery.class, SearchSort.class);
            return (ContentSearch)ctr.newInstance(query, sort);
        }
        catch (NoSuchMethodException e) {
            log.debug("New ContentSearch constructor not found, falling back to old constructor...");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.debug("Found new ContentSearch constructor, but could not instantiate with it");
        }
        try {
            Constructor<?>[] ctrs;
            for (Constructor<?> ctr : ctrs = ContentSearch.class.getConstructors()) {
                if (ctr.getGenericParameterTypes().length != 4) continue;
                return (ContentSearch)ctr.newInstance(query, sort, null, null);
            }
            log.debug("Could not find old ContentSearch constructor with desired signature");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.debug("Found old ContentSearch constructor, but could not instantiate with it");
        }
        log.debug("Attempt to re-instantiate new constructor, if it fails throw a ReflectiveOperationException");
        Constructor ctr = ContentSearch.class.getConstructor(SearchQuery.class, SearchSort.class);
        return (ContentSearch)ctr.newInstance(query, sort);
    }
}

