/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service;

import co.uk.automationconsultants.compliance.cache.SpaceSettingsCache;
import co.uk.automationconsultants.compliance.entity.ClassificationLevel;
import co.uk.automationconsultants.compliance.entity.SettingEntity;
import co.uk.automationconsultants.compliance.impl.SortByPrimaryKey;
import co.uk.automationconsultants.compliance.json.level.LevelJson;
import co.uk.automationconsultants.compliance.json.level.LevelRestrictionJson;
import co.uk.automationconsultants.compliance.json.page.PageClassificationHistoryJson;
import co.uk.automationconsultants.compliance.json.page.PageClassificationIconJson;
import co.uk.automationconsultants.compliance.json.page.PageClassificationNameJson;
import co.uk.automationconsultants.compliance.json.page.PageClassificationTooltipJson;
import co.uk.automationconsultants.compliance.json.page.PageClassificationValueJson;
import co.uk.automationconsultants.compliance.json.settings.GlobalSettingsJson;
import co.uk.automationconsultants.compliance.json.settings.SpaceSettingsPropertyJson;
import co.uk.automationconsultants.compliance.service.NotificationService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.validation.ValidationError;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.atlassian.plugins.rest.common.json.JsonMarshallingException;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="classificationService")
public class ClassificationService {
    private static final Logger log = LoggerFactory.getLogger(ClassificationService.class);
    public static final String SPACE_CONTENT_KEY = "dataclassification";
    public static final String PAGE_CONTENT_KEY = "classification";
    public static final String PAGE_HISTORY_CONTENT_KEY = "classificationhistory";
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final ContentPermissionManager contentPermissionManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final JaxbJsonMarshaller jaxbJsonMarshaller;
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final ContentPropertyService contentPropertyService;
    @ComponentImport
    private final ContentService contentService;
    private final NotificationService notificationService;
    @ComponentImport
    private final EntityManagerProvider entityManagerProvider;
    private final SpaceSettingsCache spaceSettingsCache;

    @Inject
    public ClassificationService(TransactionTemplate transactionTemplate, GroupManager groupManager, ContentPermissionManager contentPermissionManager, UserAccessor userAccessor, PermissionManager permissionManager, PageManager pageManager, JaxbJsonMarshaller jaxbJsonMarshaller, ActiveObjects activeObjects, ContentPropertyService contentPropertyService, ContentService contentService, NotificationService notificationService, EntityManagerProvider entityManagerProvider, SpaceSettingsCache spaceSettingsCache) {
        this.transactionTemplate = transactionTemplate;
        this.groupManager = groupManager;
        this.contentPermissionManager = contentPermissionManager;
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.pageManager = pageManager;
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
        this.activeObjects = activeObjects;
        this.contentPropertyService = contentPropertyService;
        this.contentService = contentService;
        this.notificationService = notificationService;
        this.entityManagerProvider = entityManagerProvider;
        this.spaceSettingsCache = spaceSettingsCache;
    }

    public static PageClassificationValueJson getNewPageClassificationJson(String username, int index, List<LevelJson> levels) {
        LevelJson newLevel = levels.get(index);
        String newDate = new Date().toLocaleString();
        return new PageClassificationValueJson(new PageClassificationNameJson(newLevel.getName(), newLevel.getName(), index), new PageClassificationIconJson("/images/" + newLevel.getColour() + ".png"), new PageClassificationTooltipJson("Classified as " + newLevel.getName() + " by " + username + " on " + newDate), newDate);
    }

    public static PageClassificationHistoryJson getNewPageClassificationHistoryJson(String username, int index, List<LevelJson> levels) {
        LevelJson newLevel = levels.get(index);
        Date newDate = new Date();
        return new PageClassificationHistoryJson(newLevel.getName(), username, newLevel.getColour(), newDate);
    }

    public List<LevelJson> getLevels() {
        ArrayList<LevelJson> levels = new ArrayList<LevelJson>();
        SettingEntity[] settingEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class);
        if (settingEntities.length > 0) {
            Arrays.sort(settingEntities, new SortByPrimaryKey());
            SettingEntity settingEntity = settingEntities[settingEntities.length - 1];
            ClassificationLevel[] classificationLevels = settingEntity.getClassificationLevels();
            Arrays.sort(classificationLevels, new SortByPrimaryKey());
            for (ClassificationLevel classificationLevel : classificationLevels) {
                levels.add(new LevelJson(classificationLevel.getName(), "", classificationLevel.getColour()));
            }
        } else {
            levels.add(new LevelJson("Highly Restricted", "", "dark-red"));
            levels.add(new LevelJson("Restricted", "", "orange"));
            levels.add(new LevelJson("Internal", "", "blue"));
            levels.add(new LevelJson("Public", "", "green"));
        }
        return levels;
    }

    public SpaceSettingsPropertyJson getSpaceSettings(String spaceKey) {
        return this.spaceSettingsCache.get(spaceKey);
    }

    private boolean setComplianceContentProperty(long contentId, int level, String username, List<LevelJson> levelJsons, boolean isAutomatedAction) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            Content content;
            JsonContentProperty existingLevel;
            String contentPropertyFormattedString = "{} - Set Content Property. Time taken: {}ms";
            long startTime = System.currentTimeMillis();
            ContentId contentId1 = ContentId.valueOf((String)String.valueOf(contentId));
            if (!isAutomatedAction) {
                this.entityManagerProvider.getEntityManager().clear();
            }
            if ((existingLevel = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(contentId1).withPropertyKey(PAGE_CONTENT_KEY).fetchOneOrNull()) != null) {
                try {
                    ValidationResult validationResult = this.contentPropertyService.validator().validateDelete(existingLevel);
                    if (validationResult.isValid()) {
                        this.contentPropertyService.delete(existingLevel);
                    } else {
                        log.error("Compliance Error: Existing Level Deletion Invalid During Set Compliance CP");
                    }
                }
                catch (ServiceException e) {
                    log.error("Compliance Error: Service Exception During Set Compliance CP");
                }
            }
            if ((content = (Content)this.contentService.find(new Expansion[0]).withId(contentId1).fetchOneOrNull()) != null) {
                PageClassificationValueJson newPageClassificationJson = ClassificationService.getNewPageClassificationJson(username, level, levelJsons);
                String newPageClassificationString = this.getPageClassificationString(newPageClassificationJson);
                JsonContentProperty.ContentPropertyBuilder property = JsonContentProperty.builder().content(content).key(PAGE_CONTENT_KEY).value(new JsonString(newPageClassificationString));
                ValidationResult validationResult = this.contentPropertyService.validator().validateCreate(property.build());
                if (validationResult.isSuccessful()) {
                    this.contentPropertyService.create(property.build());
                } else {
                    log.error("Compliance for Confluence - Error Creating New Content Property");
                    for (ValidationError error : validationResult.getErrors()) {
                        log.error(error.getMessage().toString());
                    }
                }
                log.debug("{} - Set Content Property. Time taken: {}ms", (Object)contentId, (Object)(System.currentTimeMillis() - startTime));
                return true;
            }
            log.debug("{} - Set Content Property. Time taken: {}ms", (Object)contentId, (Object)(System.currentTimeMillis() - startTime));
            return false;
        });
    }

    private boolean setComplianceHistoryContentProperty(long contentId, int level, String username) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            long startTime = System.currentTimeMillis();
            String historyFormattedString = "{} - Set History Content Property. Time taken: {}ms";
            List<LevelJson> levels = this.getLevels();
            ContentId contentId1 = ContentId.valueOf((String)String.valueOf(contentId));
            JsonContentProperty existingHistory = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(contentId1).withPropertyKey(PAGE_HISTORY_CONTENT_KEY).fetchOneOrNull();
            Content content = (Content)this.contentService.find(new Expansion[0]).withId(contentId1).fetchOneOrNull();
            PageClassificationHistoryJson newPageClassificationJson = ClassificationService.getNewPageClassificationHistoryJson(username, level, levels);
            String newPageClassificationHistoryString = this.getPageClassificationHistoryString(newPageClassificationJson);
            if (existingHistory != null) {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    PageClassificationHistoryJson[] pageClassificationHistoryJsons = (PageClassificationHistoryJson[])mapper.readValue(existingHistory.getValue().getValue(), PageClassificationHistoryJson[].class);
                    ArrayList<PageClassificationHistoryJson> pageClassificationHistoryJsons1 = new ArrayList<PageClassificationHistoryJson>(Arrays.asList(pageClassificationHistoryJsons));
                    pageClassificationHistoryJsons1.add(0, newPageClassificationJson);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (PageClassificationHistoryJson pageClassificationHistoryJson : pageClassificationHistoryJsons1) {
                        stringBuilder.append(this.getPageClassificationHistoryString(pageClassificationHistoryJson)).append(",");
                    }
                    stringBuilder.setLength(stringBuilder.length() - 1);
                    JsonContentProperty.ContentPropertyBuilder property = JsonContentProperty.builder().content(content).key(PAGE_HISTORY_CONTENT_KEY).value(new JsonString("[" + stringBuilder.toString() + "]"));
                    if (existingHistory == null) {
                        this.contentPropertyService.create(property.build());
                    } else {
                        Version currentVersion = existingHistory.getVersion();
                        this.contentPropertyService.update(property.version(Version.builder().number(currentVersion.getNumber() + 1).build()).build());
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
                log.debug(historyFormattedString, (Object)contentId, (Object)(System.currentTimeMillis() - startTime));
                return true;
            }
            if (content != null) {
                JsonContentProperty property = JsonContentProperty.builder().content(content).key(PAGE_HISTORY_CONTENT_KEY).value(new JsonString("[" + newPageClassificationHistoryString + "]")).build();
                this.contentPropertyService.create(property);
                log.debug(historyFormattedString, (Object)contentId, (Object)(System.currentTimeMillis() - startTime));
                return true;
            }
            log.debug(historyFormattedString, (Object)contentId, (Object)(System.currentTimeMillis() - startTime));
            return false;
        });
    }

    private String getPageClassificationString(PageClassificationValueJson json) {
        try {
            String marshal = this.jaxbJsonMarshaller.marshal((Object)json);
            return marshal;
        }
        catch (JsonMarshallingException e) {
            log.error("Compliance for Confluence - Error Marshalling Page Classification String" + e.getMessage());
            return null;
        }
    }

    private String getPageClassificationHistoryString(PageClassificationHistoryJson json) {
        try {
            String marshal = this.jaxbJsonMarshaller.marshal((Object)json);
            return marshal;
        }
        catch (JsonMarshallingException e) {
            log.error("Compliance for Confluence - Error Marshalling Page Classification History String" + e.getMessage());
            return null;
        }
    }

    private boolean isConsistent(LevelRestrictionJson levelRestrictionJson, Page page) {
        HashSet<String> setGroupPermission = new HashSet<String>(levelRestrictionJson.getGroups());
        HashSet<String> setUserPermission = new HashSet<String>(levelRestrictionJson.getusers());
        HashSet<String> actualGroupPermission = new HashSet<String>();
        HashSet<String> actualUserPermission = new HashSet<String>();
        if (page.hasContentPermissions()) {
            ContentPermissionSet contentPermissions = page.getContentPermissionSet("Edit");
            if (contentPermissions != null) {
                for (ContentPermission cp : contentPermissions) {
                    if (cp.isGroupPermission()) {
                        actualGroupPermission.add(cp.getGroupName().toLowerCase());
                        continue;
                    }
                    if (!cp.isUserPermission()) continue;
                    actualUserPermission.add(cp.getUserSubject().getLowerName());
                }
                return setGroupPermission.equals(actualGroupPermission) && setUserPermission.equals(actualUserPermission);
            }
            return false;
        }
        return false;
    }

    public boolean performClassification(long pageId, User user, int level, SpaceSettingsPropertyJson spaceSettings, List<LevelJson> levels, GlobalSettingsJson settings, boolean isAutomatedAction) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            Page page = this.pageManager.getPage(pageId);
            if (page == null) {
                log.debug("Page is null - malformed request, cannot classify page");
                return false;
            }
            log.debug("{} - Page is not null", (Object)pageId);
            if (spaceSettings != null && !spaceSettings.isEnabled()) {
                log.debug("Classification is not enabled, not doing anything");
                return true;
            }
            if (!isAutomatedAction) {
                this.entityManagerProvider.getEntityManager().clear();
            }
            ContentId contentId1 = ContentId.valueOf((String)String.valueOf(pageId));
            JsonContentProperty existingLevel = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(contentId1).withPropertyKey(PAGE_CONTENT_KEY).fetchOneOrNull();
            ObjectMapper mapper = new ObjectMapper();
            try {
                boolean setClassification;
                PageClassificationValueJson pageClassificationValueJson = null;
                if (existingLevel != null) {
                    log.debug("{} - There is an existing level", (Object)pageId);
                    pageClassificationValueJson = (PageClassificationValueJson)mapper.readValue(existingLevel.getValue().getValue(), PageClassificationValueJson.class);
                }
                boolean restrictGloballyControlled = Boolean.TRUE.equals(settings.getRestrictGloballyControlled());
                boolean restrictionsEnabledGlobally = Boolean.TRUE.equals(settings.getRestrict());
                if (!restrictGloballyControlled && spaceSettings == null || existingLevel == null) {
                    log.debug("{} - Space settings haven't been created yet, or there's no existing level. Setting the classification property", (Object)pageId);
                    setClassification = this.setComplianceContentProperty(pageId, level, user.getName(), levels, isAutomatedAction);
                } else {
                    List<LevelRestrictionJson> restrictions;
                    List<LevelRestrictionJson> list = restrictions = restrictGloballyControlled ? settings.getRestrictions() : spaceSettings.getLevelRestrictions();
                    if (!restrictions.isEmpty() && level < restrictions.size()) {
                        LevelRestrictionJson currentRestriction = restrictions.get(level);
                        if (pageClassificationValueJson.getName().index == level && this.isConsistent(currentRestriction, page)) {
                            log.debug("Attempting to classify as the same level and restrictions haven't changed, not doing anything.");
                            return true;
                        }
                        log.debug("Restrictions check completed, we need to set classification property. Attempting to set now.");
                        setClassification = this.setComplianceContentProperty(pageId, level, user.getName(), levels, isAutomatedAction);
                    } else {
                        log.debug("Auto Restrict values are empty, just set classification property");
                        setClassification = this.setComplianceContentProperty(pageId, level, user.getName(), levels, isAutomatedAction);
                    }
                }
                if (!setClassification) {
                    log.debug("Failed to set classification property.");
                    return false;
                }
                if (existingLevel == null || pageClassificationValueJson.getName().index != level) {
                    log.debug("Classification property set, attempting to set history property");
                    this.setComplianceHistoryContentProperty(pageId, level, user.getName());
                }
                if (restrictGloballyControlled && restrictionsEnabledGlobally || !restrictGloballyControlled && spaceSettings != null && spaceSettings.isRestricted()) {
                    boolean bl;
                    log.debug("Attempting to set restrictions.");
                    int restrictionStatus = this.setRestriction(pageId, user, level);
                    if (restrictionStatus != 200 && restrictionStatus != 201) {
                        bl = false;
                        return bl;
                    }
                    bl = true;
                    return bl;
                }
                log.debug("Returning true, no restriction to apply.");
                return true;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                log.debug("Caught exception:");
                log.debug(sw.toString());
            }
            log.debug("Failed, for some reason");
            return false;
        });
    }

    public GlobalSettingsJson getSettings() {
        SettingEntity[] settings = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
        if (settings.length > 0) {
            ObjectMapper objectMapper = new ObjectMapper();
            GlobalSettingsJson globalSettingsJson = new GlobalSettingsJson();
            globalSettingsJson.setPreface(settings[0].getMacroPreface() != null ? settings[0].getMacroPreface() : "Data Classification: ");
            globalSettingsJson.setManageDefaultLevelGlobally(settings[0].getManageDefaultLevelGlobally() != null ? settings[0].getManageDefaultLevelGlobally() : false);
            globalSettingsJson.setGlobalDefaultLevel(settings[0].getGlobalDefaultLevel() != null ? settings[0].getGlobalDefaultLevel() : -1);
            globalSettingsJson.setForce(settings[0].getForce() != null ? settings[0].getForce() : false);
            globalSettingsJson.setInherit(settings[0].getInherit() != null ? settings[0].getInherit() : false);
            globalSettingsJson.setPrintOnly(settings[0].getPrintOnly() != null ? settings[0].getPrintOnly() : true);
            globalSettingsJson.setSize(settings[0].getMacroSize() != null ? settings[0].getMacroSize() : "medium");
            globalSettingsJson.setSpaceData(settings[0].getSpaceData() != null ? settings[0].getSpaceData() : true);
            globalSettingsJson.setSpaceLevel(settings[0].getSpaceLevel() != null ? settings[0].getSpaceLevel() : true);
            globalSettingsJson.setDataByline(settings[0].getDataByline() != null ? settings[0].getDataByline() : true);
            globalSettingsJson.setForceGloballyControlled(settings[0].getGloballyControlledForce() != null ? settings[0].getGloballyControlledForce() : false);
            globalSettingsJson.setRestrict(settings[0].getRestrict() != null ? settings[0].getRestrict() : false);
            globalSettingsJson.setRestrictGloballyControlled(settings[0].getRestrictGloballyControlled() != null ? settings[0].getRestrictGloballyControlled() : false);
            globalSettingsJson.setClassificationGloballyControlled(settings[0].getClassiGloballyControlled() != null ? settings[0].getClassiGloballyControlled() : false);
            globalSettingsJson.setClassificationEnabled(settings[0].isClassificationEnabled() != null ? settings[0].isClassificationEnabled() : true);
            globalSettingsJson.setOnlyCheckEditPerms(settings[0].getOnlyCheckEditPerms() != null && settings[0].getOnlyCheckEditPerms() != false);
            try {
                globalSettingsJson.setRestrictions(settings[0].getRestrictions() != null ? (List)objectMapper.readValue(settings[0].getRestrictions(), (TypeReference)new TypeReference<List<LevelRestrictionJson>>(){}) : null);
            }
            catch (IOException e) {
                log.error("Could not parse Restrictions");
                e.printStackTrace();
            }
            return globalSettingsJson;
        }
        return new GlobalSettingsJson("", "medium", true, false, -1, false, false, true, true, true, false, false, false, null, false, true, false);
    }

    private int setRestriction(long pageId, User user, int level) {
        int restrictionStatus;
        long startTime = System.currentTimeMillis();
        Page page = this.pageManager.getPage(pageId);
        String spaceKey = page.getSpaceKey();
        SpaceSettingsPropertyJson spaceSettings = this.getSpaceSettings(spaceKey);
        GlobalSettingsJson globalSettings = this.getSettings();
        boolean restrictGloballyControlled = Boolean.TRUE.equals(globalSettings.getRestrictGloballyControlled());
        boolean isRestricted = Boolean.TRUE.equals(globalSettings.getRestrict());
        if (restrictGloballyControlled && isRestricted) {
            restrictionStatus = this.applyRestriction(level, globalSettings.getRestrictions(), user, page, globalSettings);
        } else if (!restrictGloballyControlled && spaceSettings != null && spaceSettings.isEnabled() && spaceSettings.isRestricted()) {
            List<LevelRestrictionJson> levelRestrictions = spaceSettings.getLevelRestrictions();
            restrictionStatus = this.applyRestriction(level, levelRestrictions, user, page, globalSettings);
        } else {
            restrictionStatus = 201;
        }
        log.debug("{} - Set Restrictions. Time taken: {}.ms ", (Object)pageId, (Object)(System.currentTimeMillis() - startTime));
        return restrictionStatus;
    }

    private Set<ContentPermission> filterPermissionByType(Set<ContentPermission> permissions, String permissionType) {
        return permissions.stream().filter(permission -> permission.getType().equals(permissionType)).collect(Collectors.toSet());
    }

    private int applyRestriction(int level, List<LevelRestrictionJson> levelRestrictions, User user, Page page, GlobalSettingsJson globalSettings) {
        if (level < levelRestrictions.size() && levelRestrictions.get(level) != null) {
            ArrayList users = levelRestrictions.get(level).getusers() != null ? levelRestrictions.get(level).getusers() : new ArrayList();
            ArrayList groups = levelRestrictions.get(level).getGroups() != null ? levelRestrictions.get(level).getGroups() : new ArrayList();
            ArrayList<String> roles = levelRestrictions.get(level).getRoles() != null ? levelRestrictions.get(level).getRoles() : new ArrayList<String>();
            boolean hasPermission = false;
            hasPermission = Boolean.TRUE.equals(globalSettings.getOnlyCheckEditPerms()) ? this.permissionManager.hasPermission(user, Permission.EDIT, (Object)page) : this.permissionManager.hasPermission(user, Permission.SET_PERMISSIONS, (Object)page);
            if (page == null) {
                return 400;
            }
            if (!hasPermission) {
                return 403;
            }
            if (users.size() == 0 && groups.size() == 0 && roles.size() == 0) {
                HashMap emptyHashMap = new HashMap();
                emptyHashMap.put("Edit", new HashSet());
                emptyHashMap.put("View", new HashSet());
                this.contentPermissionManager.setContentPermissions(emptyHashMap, (ContentEntityObject)page);
                return 200;
            }
            HashMap hashMap = new HashMap();
            hashMap.put("Edit", new HashSet());
            hashMap.put("View", new HashSet());
            for (String username : users) {
                if (!this.userAccessor.exists(username) || this.userAccessor.isDeactivated(username)) continue;
                ((Collection)hashMap.get("View")).add(ContentPermission.createUserPermission((String)"View", (ConfluenceUser)this.userAccessor.getUserByName(username)));
                ((Collection)hashMap.get("Edit")).add(ContentPermission.createUserPermission((String)"Edit", (ConfluenceUser)this.userAccessor.getUserByName(username)));
            }
            if (user != null && user.getName() != null && !users.contains(user.getName())) {
                ((Collection)hashMap.get("View")).add(ContentPermission.createUserPermission((String)"View", (ConfluenceUser)this.userAccessor.getUserByName(user.getName())));
                ((Collection)hashMap.get("Edit")).add(ContentPermission.createUserPermission((String)"Edit", (ConfluenceUser)this.userAccessor.getUserByName(user.getName())));
            }
            for (String groupName : groups) {
                try {
                    Group group = this.groupManager.getGroup(groupName);
                    if (group == null) continue;
                    ((Collection)hashMap.get("View")).add(ContentPermission.createGroupPermission((String)"View", (String)groupName));
                    ((Collection)hashMap.get("Edit")).add(ContentPermission.createGroupPermission((String)"Edit", (String)groupName));
                }
                catch (EntityException e) {
                    log.error("Encountered exception: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            Set<ContentPermission> rolePermissions = this.getPermissionsForRoles(roles, page);
            Set<ContentPermission> roleViewPermissions = this.filterPermissionByType(rolePermissions, "View");
            Set<ContentPermission> roleEditPermissions = this.filterPermissionByType(rolePermissions, "Edit");
            ((Collection)hashMap.get("View")).addAll(roleViewPermissions);
            ((Collection)hashMap.get("Edit")).addAll(roleEditPermissions);
            this.contentPermissionManager.setContentPermissions(hashMap, (ContentEntityObject)page);
            return 200;
        }
        return 201;
    }

    private Stream<SpacePermission> getSpaceAdminPermissionsStream(Page page) {
        return page.getSpace().getPermissions().stream().filter(permission -> permission.getType().equals("SETSPACEPERMISSIONS"));
    }

    private Set<ContentPermission> generateContentPermissionsFromSpacePermission(SpacePermission permission) {
        if (permission.isGroupPermission()) {
            return new HashSet<ContentPermission>(Arrays.asList(ContentPermission.createGroupPermission((String)"Edit", (String)permission.getGroup()), ContentPermission.createGroupPermission((String)"View", (String)permission.getGroup())));
        }
        if (permission.isUserPermission()) {
            return new HashSet<ContentPermission>(Arrays.asList(ContentPermission.createUserPermission((String)"Edit", (ConfluenceUser)Objects.requireNonNull(permission.getUserSubject())), ContentPermission.createUserPermission((String)"View", (ConfluenceUser)permission.getUserSubject())));
        }
        return new HashSet<ContentPermission>();
    }

    public Set<ContentPermission> getPermissionsForRoles(List<String> roles, Page page) {
        HashSet<ContentPermission> permissions = new HashSet<ContentPermission>();
        Iterator<String> iterator = roles.iterator();
        while (iterator.hasNext()) {
            String role;
            switch (role = iterator.next()) {
                case "pageCreator": {
                    if (page.getCreator() == null) break;
                    permissions.add(ContentPermission.createUserPermission((String)"View", (ConfluenceUser)page.getCreator()));
                    permissions.add(ContentPermission.createUserPermission((String)"Edit", (ConfluenceUser)page.getCreator()));
                    break;
                }
                case "pageCollaborator": {
                    Set collaboratorPermissions = this.notificationService.getPageCollaborators(page).stream().map(user -> new HashSet<ContentPermission>(Arrays.asList(ContentPermission.createUserPermission((String)"Edit", (ConfluenceUser)user), ContentPermission.createUserPermission((String)"View", (ConfluenceUser)user)))).reduce((set1, set2) -> {
                        set1.addAll(set2);
                        return set1;
                    }).orElse(new HashSet());
                    permissions.addAll(collaboratorPermissions);
                    break;
                }
                case "spaceAdmin": {
                    Set spaceAdminPermissions = this.getSpaceAdminPermissionsStream(page).map(this::generateContentPermissionsFromSpacePermission).reduce((set1, set2) -> {
                        set1.addAll(set2);
                        return set1;
                    }).orElse(new HashSet());
                    permissions.addAll(spaceAdminPermissions);
                    break;
                }
            }
        }
        return permissions;
    }
}

