$(function() {
    var page = $(".page");
    var byline = $("#classify-page-byline");
    var editorByline = $('#editor-compliance-byline');
    var editorLevel = null;
    var editorSaveClick = null;
    var editorSaveClickEvent = null;

    // Drop in AMD module replacement for deprecated AJS global
    const AJSModule = require('ajs');

    function getLozengeClass(classification, levels) {
        for (var i = 0; i < levels.length; i++) {
            if (levels[i].name === classification) {
                return levels[i].colour;
            }
        }
        return "default";
    }

    function getLozengeTextColour(classification, levels) {
        var colourName = getLozengeClass(classification, levels);
        if (colourName === "orange" || colourName === "yellow" || colourName === "light-green" || colourName === "white") {
            return "#333333";
        }
        return "#ffffff";
    }

    function setUpBylineLozenge(index, tooltip, levels, element) {
        if (index > (levels.length - 1)) {
            element.html('<span style="color:#333333;font-size:11px;bottom:1px;position:relative;" class="lozenge">Classification Lost</span>');
            element.attr("title", "The Level of this Page has been lost due to a reset, please set a new Classification Level.");
        } else {
            element.html('<span style="color:' + getLozengeTextColour(levels[index].name, levels) + ';font-size:11px;bottom:1px;position:relative;" class="lozenge lozenge-' + levels[index].colour + '">' + levels[index].name + '</span>');
            element.attr("title", tooltip);
        }
    }

    function getFromDraftId() {
        return new Promise(function (resolve, reject) {
            $.ajax({
                url: AJS.contextPath() + '/rest/server-classification/1.0/drafts?shareId=' + AJS.params.draftId,
                contentType: "application/json",
                success: function (data) { resolve(data); },
                error: function () { resolve(null); },
                headers: { 'Accept': 'application/json' }
            });
        });
    }

    function setUsingDraftId(level) {
        return new Promise(function (resolve, reject) {
            $.ajax({
                url: AJS.contextPath() + '/rest/server-classification/1.0/drafts',
                contentType: "application/json",
                type: 'POST',
                dataType: 'json',
                data: JSON.stringify({draftId: Number(AJS.params.draftId), level: level}),
                success: function (data) {
                    editorLevel = level;
                    resolve(true);
                },
                error: function () {
                    resolve(false);
                },
                headers: {
                    'Accept': 'application/json'
                }
            });
        });
    }

    function getProperty(proptype) {
        return new Promise(function (resolve, reject) {
            $.ajax({
                url: AJS.contextPath() + "/rest/api/content/" + /*AJS.params.pageId*/ AJS.params.latestPageId + "/property/" + proptype,
                contentType: "application/json",
                success: function (data) { resolve(data); },
                error: function () { reject(); },
                headers: { "Accept": "application/json" }
            });
        });
    }

    function getSpaceSettings() {
        return new Promise(function (resolve, reject) {
            $.ajax({
                url: AJS.contextPath() + "/rest/api/space/" + AJS.params.spaceKey + "/property/dataclassification",
                success: function (response) { resolve(response.value); },
                error: function () { resolve({ enabled: true, restricted: false, force: false }); },
                contentType: "application/json"
            });
        });
    }

    // This GET cannot be integrated into the above getSpaceSettings until we have migrated
    // all the space settings from content properties -> database table properly
    function getSpaceDefaultLevel() {
        return new Promise(function (resolve, reject) {
            $.ajax({
                url: AJS.contextPath() + "/rest/server-classification/1.0/spaceSetting?spaceKey=" + AJS.params.spaceKey,
                success: function (response) { resolve(response?.spaceDefaultLevel ?? -1) },
                error: function () { resolve(-1); },
                contentType: "application/json"
            });
        });
    }

    function getGlobalSettings() {
        return new Promise(function (resolve, reject) {
            $.ajax({
                url: AJS.contextPath() + "/rest/server-classification/1.0/global",
                success: function (response) { resolve(response); },
                error: function () { resolve({ dataByline: true, force: false, forceGloballyControlled: false, preface: "Data Classification: ", printOnly: true, size: "medium", spaceData: true, spaceLevel: true }); },
                contentType: "application/json"
            });
        });
    }

    function setClassification(classificationName, index, levels) {
        $.ajax({
            url: AJS.contextPath() + '/rest/server-classification/1.0/classify?pid=' + AJS.params.latestPageId + '&lid=' + index,
            type: 'POST',
            contentType: "application/json",
            success: function () {
                if ($('body').hasClass('contenteditor')) {
                    getProperty('classification').then(function (json) {
                        editorLevel = json.value.name.index;
                        setUpBylineLozenge(index, json.value.tooltip.value, levels, editorByline);
                    });
                } else {
                    setUpBylineLozenge(index, classificationName);
                }
            },
            error: function () {}
        });
    }

    function getClassificationNames() {
        return new Promise(function (resolve, reject) {
            $.ajax({
                url: AJS.contextPath() + "/rest/server-classification/1.0/level",
                success: function (response) { resolve(JSON.parse(response).levels); },
                error: function (error) {
                    resolve([
                        {name: AJS.I18n.getText("compliance.plugin.js.level.highly.restricted"), description: "", color: "dark-red"},
                        {name: AJS.I18n.getText("compliance.plugin.js.level.restricted"), description: "", color: "orange"},
                        {name: AJS.I18n.getText("compliance.plugin.js.level.internal"), description: "", color: "blue"},
                        {name: AJS.I18n.getText("compliance.plugin.js.level.public"), description: "", color: "green"}
                    ]);
                },
                contentType: "application/json",
                dataType: "html"
            });
        });
    }

    function onViewPage(globalSettings, spaceSettings) {
        getClassificationNames().then(function (levels) {
            getProperty('classification').then(function (classification) {
                setUpBylineLozenge(classification.value.name.index, classification.value.tooltip.value, levels, byline);
                byline.removeAttr("href");
                $("#classify-page-byline-wrapper").css("padding", "5px 0px 5px 0");
                page.append(
                    '<aui-inline-dialog alignment="bottom left" id="byline-expansion">' +
                        '<div id="compliance-byline-root" class="container classify-container">' + AJS.I18n.getText("compliance.plugin.js.loading") + '</div>' +
                    '</aui-inline-dialog>');
                byline.attr('aria-controls', 'byline-expansion');
                byline.attr('data-aui-trigger', true);
                byline.click(function () {
                    WRM.require("co.uk.jackgraves.classification.server-classification:compliance-react-resources", function () {
                        complianceForConfluence.render("compliance-byline-root");
                    });
                });
                if(AJS.params.latestPageId !== AJS.params.pageId) {
                    byline.off();
                }
            }).catch(function(error) {
                // If you can't get the classification property then it might not have been set. Return Pending Level
                byline.html('<span style="font-size:11px;bottom:1px;position:relative;" class="aui-lozenge aui-lozenge-subtle">' + AJS.I18n.getText("compliance.plugin.js.pending.level") + '</span>');
                byline.removeAttr("href");
                $("#classify-page-byline-wrapper").css("padding", "5px 0px 5px 0");
                page.append(
                    '<aui-inline-dialog alignment="bottom left" id="byline-expansion">' +
                    '<div id="compliance-byline-root" class="container classify-container">Loading...</div>' +
                    '</aui-inline-dialog>');
                byline.attr('aria-controls', 'byline-expansion');
                byline.attr('data-aui-trigger', true);
                byline.click(function () {
                    WRM.require("co.uk.jackgraves.classification.server-classification:compliance-react-resources", function () {
                        complianceForConfluence.render("compliance-byline-root");
                    });
                });
                if(AJS.params.latestPageId !== AJS.params.pageId) {
                    byline.off();
                }
            });
        });
        AJS.bind('rte-ready', function () {
            // rte-ready runs when the editor is ready, but it also whens when the inline comment dialog opens
            // so we also need to check to make sure the body has the contenteditor class to ensure we're in the real page editor
            if($('body').hasClass('contenteditor')) {
                handleEditPage(globalSettings, spaceSettings);
            }
        });
    }

    /**
     * Opens the editor dialog
     * @param levels classification levels on the system
     * @param deferred optional deferred object made using Jquery.Deferred()
     * @param e event to be passed with deferred object
     */
    function openEditorDialog(levels, deferred, e) {
        // Show
        AJS.dialog2("#compliance-dialog").show();
        // Populate
        $('#classification-container').html("");
        for (var i = 0; i < levels.length; i++) {
            $('#classification-container').append(
                "<a style=\"margin-bottom: -14px;\" class=\"radio\"><input style=\"margin-top:4px; cursor: pointer;\" class=\"radio\" data-int-name=\"" + levels[i].name + "\" type=\"radio\" name=\"classify-option\" id=\"dialog" + i + "\" data-colour='" + levels[i].colour + "'><label data-int-name=\"" + levels[i].name + "\" style=\"cursor: pointer; margin-left: 8px;\" for=\"" + i + "\"><span style='margin-bottom: 20px;' class='lozenge lozenge-" + levels[i].colour + "'>" + levels[i].name + "</span></label></a>" +
                "<p style=\"padding-left: 42px;\">" + levels[i].description + "</p><div style=\"margin: 10px 0 10px 0;\"></div>"
            );
        }
        if (editorLevel !== null) {
            $('#dialog' + (editorLevel)).prop('checked', true);
        }
        // Events
        function onSelectClassification() {
            var classification = $(this).attr("data-int-name");
            AJS.dialog2("#compliance-dialog").hide();
            // Get the index of the level you want to set by comparing to array of levels
            for (var i = 0; i < levels.length; i++) {
                if (classification === levels[i].name) {
                    if (AJS.params.pageId === "0") {
                        setUsingDraftId(i).then(function () {
                            onEditorCreate();
                            if (deferred && e) {
                                deferred.resolve(e);
                            }
                        })
                    } else {
                        if (deferred && e) {
                            deferred.resolve(e);
                        }
                        setClassification(classification, i, levels);
                    }
                }
            }
        }
        $('#classification-container > a > label').off();
        $('#classification-container input.radio').click(onSelectClassification);
        $('#classification-container label').click(onSelectClassification);
    }

    function onEditorUpdate() {
        getClassificationNames().then(function (levels) {
            getProperty('classification', AJS.params.pageId).then(function (classification) {
                editorLevel = classification.value.name.index;
                setUpBylineLozenge(classification.value.name.index, classification.value.tooltip.value, levels, editorByline);
            }).catch(function() {
                // 404
            });
        });
    }

    function onEditorCreate() {
        getFromDraftId().then(function (data) {
            if (data) {
                editorLevel = data.level;
                getClassificationNames().then(function (levels) {
                    setUpBylineLozenge(editorLevel, AJS.I18n.getText("compliance.plugin.descriptor.title"), levels, editorByline);
                });
            }
        });
    }

    var latestData = false;
    var checkExistOnInterval;
    var onEditorCreateInterval;
    var onEditorUpdateInterval;

    function onEditPageCE() {
        checkExistOnInterval = setInterval(checkExist, 200);
    }

    function checkExist() {
        if (AJS.params.contentType === "page") {
            editorByline = $("#editor-compliance-byline");
            if (editorByline.length) {
                getClassificationNames().then(function(levels) {
                    // Ready editor
                    editorByline.html('<span style="font-size:11px;bottom:1px;position:relative;" class="aui-lozenge aui-lozenge-subtle">' + AJS.I18n.getText("compliance.plugin.js.pending.level") + '</span>');
                    editorByline.click(function () {
                        openEditorDialog(levels);
                    });

                    // AJS.Editor.overrideBeforeSave is used to override the save button
                    // function must return a JQuery style promise made via $.ajax(), $.Deferred or $.when()
                    AJSModule.Editor.overrideBeforeSave(function (e) {
                        const isNewPage = $("meta[name='ajs-page-id']").attr("content") === "0";
                        if (!latestData) {
                            if (isNewPage) {
                                const deferred = $.Deferred();
                                getFromDraftId().then(function (data) {
                                    if (data == null) {
                                        console.log("Could not get level from draft ID");
                                        openEditorDialog(levels, deferred, e);
                                    } else {
                                        editorLevel = data.level;
                                        setUpBylineLozenge(editorLevel, AJS.I18n.getText("compliance.plugin.descriptor.title"), levels, editorByline);
                                        deferred.resolve(e);
                                    }
                                })
                                return deferred.promise();
                            } else {
                                // Edit Page
                                const deferred = $.Deferred();
                                getProperty("classification")
                                    .then(function (classification) {
                                        editorLevel = classification.value.name.index;
                                        setUpBylineLozenge(classification.value.name.index, classification.value.tooltip.value, levels, editorByline);
                                        deferred.resolve(e);
                                    }).catch(() => {
                                        openEditorDialog(levels, deferred, e);
                                    });
                                return deferred.promise();
                            }
                        } else {
                            latestData = false;
                            const deferred = $.Deferred();
                            if (editorLevel == null) {
                                openEditorDialog(levels, deferred, e);
                            } else {
                                clearInterval(onEditorCreateInterval);
                                clearInterval(onEditorUpdateInterval);
                                deferred.resolve(e);
                            }
                            return deferred.promise();
                        }
                    });
                });

                // Check for the latest level on a 10 second interval
                if ($("meta[name='ajs-page-id']").attr("content") == "0") {
                    onEditorCreate();
                    onEditorCreateInterval = setInterval(onEditorCreate, 10000);
                } else {
                    onEditorUpdate();
                    onEditorUpdateInterval = setInterval(onEditorUpdate, 10000);
                }
            }
            clearInterval(checkExistOnInterval);
        }
    }

    function onEditPage() {
        checkExist = setInterval(function () {
            if(AJS.params.contentType === "page") {
                editorByline = $('#editor-compliance-byline');
                if (editorByline.length) {
                    getClassificationNames().then(function (levels) {
                        editorByline.html('<span style="font-size:11px;bottom:1px;position:relative;" class="aui-lozenge aui-lozenge-subtle">' + AJS.I18n.getText("compliance.plugin.js.pending.level") + '</span>');
                        editorByline.click(function () {
                            openEditorDialog(levels);
                        });

                        // Begin Intercept Save
                        const isNewPage = $("meta[name='ajs-page-id']").attr("content") === "0";
                        // AJS.Editor.overrideBeforeSave is used t o override the save button
                        // function must return a JQuery style promise made via $.ajax(), $.Deferred or $.when()
                        AJSModule.Editor.overrideBeforeSave((e) => {
                            const deferred = $.Deferred();
                            if (editorLevel == null) {
                                openEditorDialog(levels, deferred, e);
                            } else {
                                deferred.resolve(e);
                            }
                            return deferred.promise();
                        });
                        if (isNewPage) {
                            onEditorCreate();
                        } else {
                            onEditorUpdate();
                        }
                        // End Intercept Save
                    }, function () {});
                }
                clearInterval(checkExist);
            }
        }, 200);
    }

    function handleEditPage(globalSettings, spaceSettings) {
        const isNewPage = $("meta[name='ajs-page-id']").attr("content") === "0";
        const forceClassification = globalSettings.forceGloballyControlled && globalSettings.force || !globalSettings.forceGloballyControlled && spaceSettings.force;
        const defaultClassification = (globalSettings.manageDefaultLevelGlobally && globalSettings.globalDefaultLevel > -1 ||
                                      !globalSettings.manageDefaultLevelGlobally && spaceSettings.spaceDefaultLevel > -1) && isNewPage;

        if(forceClassification && !defaultClassification) {
            // shared-drafts: whether synchrony is enabled https://confluence.atlassian.com/doc/configuring-synchrony-858772125.html
            if(!AJS.Meta.getBoolean('shared-drafts')) {
                onEditPage();
            } else {
                onEditPageCE();
            }
        } else {
            $('#editor-compliance-byline').hide();
        }
    }

    // This is the main function
    if (AJS.params.spaceKey) {
        getGlobalSettings().then(function(globalSettings) {
            getSpaceSettings().then(function (spaceSettings) {
                getSpaceDefaultLevel().then(function (spaceDefaultLevel) {
                    if(spaceSettings.enabled) {
                        // View Page or Edit Page?
                        if($('body').hasClass('contenteditor')) {
                            handleEditPage(globalSettings, {...spaceSettings, spaceDefaultLevel: spaceDefaultLevel});
                        } else if(AJS.params.browsePageTreeMode === 'view') {
                            // Viewing Page
                            onViewPage(globalSettings, spaceSettings);
                        }
                    } else {
                        editorByline.hide();
                        byline.hide();
                    }
                });
            });
        });
    }
});
