/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.exception.task.InvalidParamsException;
import co.uk.automationconsultants.compliance.exception.task.InvalidTaskTypeException;
import co.uk.automationconsultants.compliance.exception.task.NoSuchTaskException;
import co.uk.automationconsultants.compliance.json.task.TaskCreationJson;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.TaskLogJson;
import co.uk.automationconsultants.compliance.json.task.search.TaskSearchFilterJson;
import co.uk.automationconsultants.compliance.search.SearchResponse;
import co.uk.automationconsultants.compliance.service.task.TaskCancellationService;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.task.TaskManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/task")
public class TaskRest {
    private final TaskCancellationService taskCancellationService;
    private final TaskDBService taskDBService;
    private final TaskManager taskManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;

    @Inject
    public TaskRest(TaskCancellationService taskCancellationService, TaskDBService taskDBService, TaskManager taskManager, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager) {
        this.taskCancellationService = taskCancellationService;
        this.taskDBService = taskDBService;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.taskManager = taskManager;
    }

    @POST
    @Path(value="/search")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response search(@Context HttpServletRequest request, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @QueryParam(value="cursor") String cursor, TaskSearchFilterJson filterJson) {
        if (this.notConfluenceAdmin(request)) {
            return Response.status((int)403).build();
        }
        SearchResponse<TaskJson> searchResponseJson = this.taskDBService.searchTasks(limit, cursor, filterJson, false);
        return Response.ok().entity(searchResponseJson).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getTask(@Context HttpServletRequest request, @PathParam(value="id") int taskId) {
        if (this.notConfluenceAdmin(request)) {
            return Response.status((int)403).build();
        }
        try {
            TaskJson task = this.taskDBService.getTask(taskId);
            if (task == null) {
                return Response.status((int)404).build();
            }
            return Response.ok((Object)task).build();
        }
        catch (Exception e) {
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="/cancel/{id}")
    public Response cancelTask(@Context HttpServletRequest request, @PathParam(value="id") int taskId) {
        if (this.notConfluenceAdmin(request)) {
            return Response.status((int)403).build();
        }
        try {
            this.taskCancellationService.cancelTask(taskId);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/log/{id}")
    @Produces(value={"application/json"})
    public Response getLogs(@Context HttpServletRequest request, @PathParam(value="id") int taskId, @QueryParam(value="expand") boolean expand, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @QueryParam(value="cursor") String cursor) {
        if (this.notConfluenceAdmin(request)) {
            return Response.status((int)403).build();
        }
        try {
            SearchResponse<TaskLogJson> logSearchResponseJson = this.taskDBService.searchTaskLogs(taskId, limit, cursor, null, expand, false);
            return Response.ok(logSearchResponseJson).build();
        }
        catch (NoSuchTaskException e) {
            return Response.status((int)404).build();
        }
        catch (Exception e) {
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addTask(@Context HttpServletRequest request, TaskCreationJson taskCreationJson) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (user == null || !this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((int)403).build();
        }
        try {
            TaskJson taskJson = this.taskManager.addTask(taskCreationJson, user.getKey().getStringValue());
            return Response.ok((Object)taskJson).build();
        }
        catch (InvalidParamsException | InvalidTaskTypeException e) {
            return Response.status((int)400).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/notify")
    @AnonymousAllowed
    public Response notifyNodeOfTask(@Context HttpServletRequest request) {
        this.taskManager.notifyTaskScanner();
        return Response.ok().build();
    }

    @GET
    @Path(value="/executor-busy")
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response checkTaskExecutorIsBusy(@Context HttpServletRequest request) {
        return Response.ok((Object)this.taskManager.isExecutorBusy()).build();
    }

    private boolean notConfluenceAdmin(HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        return !this.permissionManager.isConfluenceAdministrator((User)user);
    }
}

