/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.json.task.search;

import co.uk.automationconsultants.compliance.json.task.TaskStatusEnum;
import co.uk.automationconsultants.compliance.json.task.TaskTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TaskSearchFilterJson {
    private List<String> statuses = new ArrayList<String>();
    private List<String> taskTypes = new ArrayList<String>();
    private List<String> userIds = new ArrayList<String>();
    private List<String> managerNodes = new ArrayList<String>();
    private List<String> electedNodes = new ArrayList<String>();
    private Boolean isExclusiveExecution;

    public TaskSearchFilterJson() {
    }

    public TaskSearchFilterJson(List<String> statuses, List<String> taskTypes, List<String> userIds, List<String> managerNodes, List<String> electedNodes, Boolean isExclusiveExecution) {
        this.statuses = statuses;
        this.taskTypes = taskTypes;
        this.userIds = userIds;
        this.managerNodes = managerNodes;
        this.electedNodes = electedNodes;
        this.isExclusiveExecution = isExclusiveExecution;
    }

    public List<String> getStatuses() {
        return this.statuses;
    }

    public List<String> getTaskTypes() {
        return this.taskTypes;
    }

    public List<String> getUserIds() {
        return this.userIds;
    }

    public List<String> getManagerNodes() {
        return this.managerNodes;
    }

    public List<String> getElectedNodes() {
        return this.electedNodes;
    }

    public Boolean getExclusiveExecution() {
        return this.isExclusiveExecution;
    }

    public static TaskSearchFilterBuilder builder() {
        return new TaskSearchFilterBuilder();
    }

    public static class TaskSearchFilterBuilder {
        private String[] statuses = new String[0];
        private String[] taskTypes = new String[0];
        private String[] userIds = new String[0];
        private String[] managerNodes = new String[0];
        private String[] electedNodes = new String[0];
        private Boolean exclusiveExecution;

        public TaskSearchFilterJson build() {
            return new TaskSearchFilterJson(Arrays.asList(this.statuses), Arrays.asList(this.taskTypes), Arrays.asList(this.userIds), Arrays.asList(this.managerNodes), Arrays.asList(this.electedNodes), this.exclusiveExecution);
        }

        public TaskSearchFilterBuilder status(TaskStatusEnum ... statuses) {
            this.statuses = (String[])Arrays.stream(statuses).map(Enum::name).toArray(String[]::new);
            return this;
        }

        public TaskSearchFilterBuilder taskType(TaskTypeEnum ... taskTypes) {
            this.taskTypes = (String[])Arrays.stream(taskTypes).map(Enum::name).toArray(String[]::new);
            return this;
        }

        public TaskSearchFilterBuilder creator(String ... userIds) {
            this.userIds = userIds;
            return this;
        }

        public TaskSearchFilterBuilder managerNode(String ... managerNodes) {
            this.managerNodes = managerNodes;
            return this;
        }

        public TaskSearchFilterBuilder electedNode(String ... electedNodes) {
            this.electedNodes = electedNodes;
            return this;
        }

        public TaskSearchFilterBuilder exclusiveExecution(boolean exclusiveExecution) {
            this.exclusiveExecution = exclusiveExecution;
            return this;
        }
    }
}

