/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.condition;

import co.uk.automationconsultants.compliance.cache.SpaceSettingsCache;
import co.uk.automationconsultants.compliance.entity.SettingEntity;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import javax.inject.Inject;
import net.java.ao.Query;

public class SpaceEnabledCondition
implements Condition {
    private final SpaceSettingsCache spaceSettingsCache;
    @ComponentImport
    private final ActiveObjects activeObjects;

    @Inject
    public SpaceEnabledCondition(SpaceSettingsCache spaceSettingsCache, ActiveObjects activeObjects) {
        this.spaceSettingsCache = spaceSettingsCache;
        this.activeObjects = activeObjects;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Space space = (Space)context.get("space");
        if (space == null) {
            return false;
        }
        SettingEntity[] settings = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
        if (settings.length == 0 || Boolean.TRUE.equals(settings[0].getClassiGloballyControlled()) && Boolean.FALSE.equals(settings[0].isClassificationEnabled())) {
            return false;
        }
        return this.spaceSettingsCache.get(space.getKey()).isEnabled();
    }
}

