/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.cache;

import co.uk.automationconsultants.compliance.json.level.LevelRestrictionJson;
import co.uk.automationconsultants.compliance.json.settings.SpaceSettingsPropertyJson;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.JsonSpaceProperty;
import com.atlassian.confluence.api.service.content.SpacePropertyService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SpaceSettingsCache {
    private final Cache<String, SpaceSettingsPropertyJson> cache;

    @Inject
    public SpaceSettingsCache(CacheManager cacheManager, SpacePropertyService spacePropertyService) {
        this.cache = cacheManager.getCache(SpaceSettingsCache.class.getName() + ".spaceSettingsCache", (CacheLoader)new SpaceSettingsCacheLoader(spacePropertyService), new CacheSettingsBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).maxEntries(1000).build());
    }

    public void invalidateCache() {
        this.cache.removeAll();
    }

    public void invalidateCache(String spaceKey) {
        this.cache.remove((Object)spaceKey);
    }

    public SpaceSettingsPropertyJson get(String spaceKey) {
        return (SpaceSettingsPropertyJson)this.cache.get((Object)spaceKey);
    }

    private static class SpaceSettingsCacheLoader
    implements CacheLoader<String, SpaceSettingsPropertyJson> {
        private final SpacePropertyService spacePropertyService;
        private static final Logger logger = LoggerFactory.getLogger(SpaceSettingsCacheLoader.class);

        public SpaceSettingsCacheLoader(SpacePropertyService spacePropertyService) {
            this.spacePropertyService = spacePropertyService;
        }

        @Nonnull
        public SpaceSettingsPropertyJson load(@Nonnull String spaceKey) {
            SpaceSettingsPropertyJson spaceSettings = this.getSpaceSettings(spaceKey);
            return spaceSettings == null ? this.getDefaultSpaceSettings() : spaceSettings;
        }

        private SpaceSettingsPropertyJson getSpaceSettings(String spaceKey) {
            JsonSpaceProperty dataClassification = (JsonSpaceProperty)this.spacePropertyService.find(new Expansion[0]).withSpaceKey(spaceKey).withPropertyKey("dataclassification").fetchOrNull();
            if (dataClassification == null) {
                return null;
            }
            String value = dataClassification.getValue().getValue();
            try {
                ObjectMapper mapper = new ObjectMapper();
                return (SpaceSettingsPropertyJson)mapper.readValue(value, SpaceSettingsPropertyJson.class);
            }
            catch (IOException e) {
                logger.error("Failed to parse space settings content property {}", (Object)e.getLocalizedMessage());
                return null;
            }
        }

        private SpaceSettingsPropertyJson getDefaultSpaceSettings() {
            return new SpaceSettingsPropertyJson(true, false, false, new ArrayList<LevelRestrictionJson>(), new ArrayList<String>());
        }
    }
}

