/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.servlet;

import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AdminServlet
extends HttpServlet {
    @ComponentImport
    private final WebSudoManager webSudoManager;
    @ComponentImport
    private final UserManager userManager;

    @Inject
    public AdminServlet(WebSudoManager webSudoManager, UserManager userManager) {
        this.webSudoManager = webSudoManager;
        this.userManager = userManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getRemoteUser() == null) {
            response.sendError(401);
        } else {
            try {
                if (!this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey(request))) {
                    response.sendError(403);
                }
                this.webSudoManager.willExecuteWebSudoRequest(request);
                response.setContentType("text/html;charset=utf-8");
                HashMap params = new HashMap();
                try {
                    response.getWriter().write(VelocityUtils.getRenderedTemplate((String)"/templates/display/admin/compliance-page.vm", params));
                }
                catch (IOException e) {
                    response.sendError(500);
                }
            }
            catch (WebSudoSessionException wes) {
                this.webSudoManager.enforceWebSudoProtection(request, response);
            }
        }
    }
}

