/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service;

import co.uk.automationconsultants.compliance.entity.ComplianceNotification;
import co.uk.automationconsultants.compliance.scheduler.EmailRow;
import co.uk.automationconsultants.compliance.scheduler.PageInfo;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.mail.notification.NotificationsSender;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="notificationService")
public class NotificationService {
    private static final int EMAIL_LIMIT = 100;
    public static final String PAGE_CREATOR = "pageCreator";
    public static final String PAGE_COLLABORATOR = "pageCollaborator";
    public static final String SPACE_ADMIN = "spaceAdmin";
    private static final Logger log = LoggerFactory.getLogger(NotificationService.class);
    @ComponentImport
    private final NotificationsSender notificationsSender;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final SettingsManager settingsManager;
    @ComponentImport
    private final ActiveObjects activeObjects;

    @Inject
    public NotificationService(NotificationsSender notificationsSender, UserAccessor userAccessor, PageManager pageManager, GroupManager groupManager, SpaceManager spaceManager, SettingsManager settingsManager, ActiveObjects activeObjects) {
        this.notificationsSender = notificationsSender;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.groupManager = groupManager;
        this.settingsManager = settingsManager;
        this.activeObjects = activeObjects;
    }

    public boolean sendNotifications() {
        ComplianceNotification[] queuedNotifications = (ComplianceNotification[])this.activeObjects.find(ComplianceNotification.class, Query.select().order("RECIPIENT ASC"));
        ArrayList<ComplianceNotification> forOneUser = new ArrayList<ComplianceNotification>();
        if (queuedNotifications.length == 0) {
            return true;
        }
        if (queuedNotifications.length == 1) {
            forOneUser.add(queuedNotifications[0]);
            if (this.sendEmail(forOneUser)) {
                this.dequeueEntries(forOneUser);
                return true;
            }
            return false;
        }
        String prevUser = queuedNotifications[0].getRecipient();
        forOneUser.add(queuedNotifications[0]);
        int emailsSent = 0;
        for (int i = 1; i < queuedNotifications.length; ++i) {
            String currentUser = queuedNotifications[i].getRecipient();
            if (prevUser.equals(currentUser)) {
                forOneUser.add(queuedNotifications[i]);
                continue;
            }
            if (emailsSent > 100) break;
            boolean result = this.sendEmail(forOneUser);
            this.dequeueEntries(forOneUser);
            forOneUser.clear();
            ++emailsSent;
        }
        if (!forOneUser.isEmpty() && emailsSent <= 100) {
            boolean result = this.sendEmail(forOneUser);
            this.dequeueEntries(forOneUser);
            forOneUser.clear();
        }
        return true;
    }

    private boolean sendEmail(List<ComplianceNotification> notifications) {
        if (notifications.size() > 0) {
            notifications.sort(new SortByExtractionResult());
            String recppp = notifications.get(0).getRecipient();
            List<ConfluenceUser> recipients = this.getEmailRecipients(notifications.get(0));
            if (recipients != null) {
                String subject = "Sensitive Data Entered";
                String template = "notification.vm";
                long pageId = notifications.get(0).getExtractionResult().getPageId();
                log.debug("Page ID of extraction: " + pageId);
                log.debug("Number of notifications: " + notifications.size());
                Page page = this.pageManager.getPage(pageId);
                ArrayList<NotificationData> dataList = new ArrayList<NotificationData>();
                ArrayList<NotificationContext> contextList = new ArrayList<NotificationContext>();
                for (ConfluenceUser rec : recipients) {
                    if (rec == null) continue;
                    NotificationData notificationData = new NotificationData((User)rec, false, (ConfluenceEntityObject)page, subject, template, null);
                    dataList.add(notificationData);
                    contextList.add(notificationData.cloneContext());
                }
                ArrayList<EmailRow> entries = new ArrayList<EmailRow>();
                String prevExtractionType = notifications.get(0).getExtractionResult().getExtractionEntity().getName();
                EmailRow emailRow = new EmailRow();
                emailRow.setExtractionType(prevExtractionType);
                emailRow.addPage(new PageInfo(this.pageManager.getPage(notifications.get(0).getExtractionResult().getPageId().longValue()).getDisplayTitle(), Long.toString(notifications.get(0).getExtractionResult().getPageId())));
                for (int i = 1; i < notifications.size(); ++i) {
                    log.debug("Loop no: " + i);
                    if (prevExtractionType.equals(notifications.get(i).getExtractionResult().getExtractionEntity().getName())) {
                        log.debug("Adding page, if");
                        emailRow.addPage(new PageInfo(this.pageManager.getPage(notifications.get(i).getExtractionResult().getPageId().longValue()).getDisplayTitle(), Long.toString(notifications.get(i).getExtractionResult().getPageId())));
                        continue;
                    }
                    log.debug("Adding page, else");
                    entries.add(emailRow);
                    prevExtractionType = notifications.get(i).getExtractionResult().getExtractionEntity().getName();
                    emailRow = new EmailRow();
                    emailRow.setExtractionType(notifications.get(i).getExtractionResult().getExtractionEntity().getName());
                    emailRow.addPage(new PageInfo(this.pageManager.getPage(notifications.get(i).getExtractionResult().getPageId().longValue()).getDisplayTitle(), Long.toString(notifications.get(i).getExtractionResult().getPageId())));
                }
                entries.add(emailRow);
                for (EmailRow entry : entries) {
                    log.debug("EmailRow: ExtractionType" + entry.getExtractionType());
                }
                for (int i = 0; i < dataList.size(); ++i) {
                    NotificationContext context = (NotificationContext)contextList.get(i);
                    NotificationData da = (NotificationData)dataList.get(i);
                    ConfluenceUser re = recipients.get(i);
                    context.put("baseUrl", (Object)this.settingsManager.getGlobalSettings().getBaseUrl());
                    context.put("mailRecipient", (Object)re.getFullName());
                    context.put("subject", (Object)subject);
                    context.put("entries", entries);
                    this.notificationsSender.sendNotification(re.getName(), context, da, null);
                }
            }
            return true;
        }
        return true;
    }

    public List<ConfluenceUser> getEmailRecipients(ComplianceNotification notification) {
        ArrayList<ConfluenceUser> recipients = new ArrayList<ConfluenceUser>();
        Page page = this.pageManager.getPage(notification.getExtractionResult().getPageId().longValue());
        switch (notification.getRecipient()) {
            case "pageCreator": {
                recipients.add(page.getCreator());
                return recipients;
            }
            case "pageCollaborator": {
                return this.getPageCollaborators(page);
            }
            case "spaceAdmin": {
                return this.getSpaceAdmins(notification.getExtractionResult().getSpaceId());
            }
        }
        recipients.add(this.userAccessor.getUserByName(notification.getRecipient()));
        return recipients;
    }

    public List<ConfluenceUser> getSpaceAdmins(long spaceId) {
        Space space = this.spaceManager.getSpace(spaceId);
        ArrayList<ConfluenceUser> users = new ArrayList<ConfluenceUser>();
        if (space != null) {
            List spacePermissions = space.getPermissions();
            for (SpacePermission permission : spacePermissions) {
                if (!permission.getType().equals("SETSPACEPERMISSIONS")) continue;
                if (permission.isGroupPermission()) {
                    List<ConfluenceUser> groupUsers = this.getUsersFromGroup(permission.getGroup());
                    users.addAll(groupUsers);
                    continue;
                }
                if (!permission.isUserPermission()) continue;
                users.add(permission.getUserSubject());
            }
        }
        return users;
    }

    public List<ConfluenceUser> getPageCollaborators(Page page) {
        LinkedHashSet<ConfluenceUser> collaboratorsSet = new LinkedHashSet<ConfluenceUser>(5);
        ArrayList<ConfluenceUser> collaborators = new ArrayList<ConfluenceUser>(5);
        if (page != null) {
            int pageVersion;
            for (int version = pageVersion = page.getVersion(); version > pageVersion - 5; --version) {
                ConfluenceUser collab;
                AbstractPage prevPageVersion = this.pageManager.getPageByVersion((AbstractPage)page, version);
                if (prevPageVersion == null || (collab = prevPageVersion.getLastModifier()) == null) continue;
                collaboratorsSet.add(collab);
            }
            collaborators.addAll(collaboratorsSet);
        }
        return collaborators;
    }

    public List<ConfluenceUser> getUsersFromGroup(String groupName) {
        try {
            Group group = this.groupManager.getGroup(groupName);
            Iterable groupUsers = this.userAccessor.getMembers(group);
            ArrayList<ConfluenceUser> listGroupUsers = new ArrayList<ConfluenceUser>();
            groupUsers.forEach(listGroupUsers::add);
            return listGroupUsers;
        }
        catch (EntityException e) {
            return new ArrayList<ConfluenceUser>();
        }
    }

    private void dequeueEntries(List<ComplianceNotification> completedNotifications) {
        for (ComplianceNotification completedNotification : completedNotifications) {
            this.activeObjects.delete(new RawEntity[]{completedNotification});
        }
    }

    static class SortByExtractionResult
    implements Comparator<ComplianceNotification> {
        SortByExtractionResult() {
        }

        @Override
        public int compare(ComplianceNotification o1, ComplianceNotification o2) {
            return o1.getExtractionResult().getExtractionEntity().getName().compareTo(o2.getExtractionResult().getExtractionEntity().getName());
        }
    }
}

