/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.entity.analysis.ExtractionResult;
import co.uk.automationconsultants.compliance.json.analysis.AnalysisResultJson;
import co.uk.automationconsultants.compliance.service.AnalysisService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/analysis")
public class AnalysisRest {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final AnalysisService analysisService;

    @Inject
    public AnalysisRest(ActiveObjects activeObjects, SpaceManager spaceManager, PageManager pageManager, PermissionManager permissionManager, UserManager userManager, UserAccessor userAccessor, AnalysisService analysisService) {
        this.activeObjects = activeObjects;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.analysisService = analysisService;
    }

    @GET
    @Path(value="/page")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getResultsForPage(@Context HttpServletRequest request, @QueryParam(value="pid") long pid, @QueryParam(value="all") @DefaultValue(value="false") boolean all) {
        boolean allResults;
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        Page page = this.pageManager.getPage(pid);
        if (page == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)page)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        int version = page.getVersion();
        long pageId = page.getLatestVersion().getId();
        boolean bl = allResults = version != page.getLatestVersion().getVersion();
        if (allResults) {
            return Response.ok(AnalysisResultJson.mapAll(this.spaceManager, this.pageManager, (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, "PAGE_ID = ? AND PAGE_VERSION = ?", new Object[]{pageId, version}))).build();
        }
        return Response.ok(AnalysisResultJson.mapAll(this.spaceManager, this.pageManager, (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, "PAGE_ID = ? AND PAGE_VERSION = ? AND ACTIVE = ?", new Object[]{pageId, version, true}))).build();
    }

    @POST
    @Path(value="/execute")
    public Response runManualScan(@Context HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Runnable runnable = () -> this.analysisService.processScheduledScan(true);
        Thread thread = new Thread(runnable);
        thread.start();
        return Response.ok().build();
    }

    @POST
    @Path(value="/maintenance")
    public Response runMaintenanceScan(@Context HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.analysisService.processMaintenanceScan();
        return Response.ok().build();
    }
}

