/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.task.tasks;

import co.uk.automationconsultants.compliance.cache.SpaceSettingsCache;
import co.uk.automationconsultants.compliance.helper.SpaceHelper;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.service.BulkChangeSpaceService;
import co.uk.automationconsultants.compliance.service.ClassificationService;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.task.TaskRunnable;
import co.uk.automationconsultants.compliance.task.tasks.BulkChangeCQLTask;
import co.uk.automationconsultants.compliance.task.tasks.BulkChangeSpaceTask;
import co.uk.automationconsultants.compliance.task.tasks.ExclusiveTestTask;
import co.uk.automationconsultants.compliance.task.tasks.ParallelTestTask;
import co.uk.automationconsultants.compliance.task.tasks.SensitiveDataScanTaskFactory;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="taskFactory")
public class TaskFactory {
    private final TaskDBService taskDBService;
    private final BulkChangeSpaceService bulkChangeSpaceService;
    private final SpaceHelper spaceHelper;
    private final SpaceSettingsCache spaceSettingsCache;
    @ComponentImport
    private final CQLSearchService cqlSearchService;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private final ClassificationService classificationService;
    private final SensitiveDataScanTaskFactory sensitiveDataScanTaskFactory;

    @Inject
    public TaskFactory(TaskDBService taskDBService, BulkChangeSpaceService bulkChangeSpaceService, SpaceHelper spaceHelper, SpaceSettingsCache spaceSettingsCache, CQLSearchService cqlSearchService, TransactionTemplate transactionTemplate, ClassificationService classificationService, SensitiveDataScanTaskFactory sensitiveDataScanTaskFactory) {
        this.taskDBService = taskDBService;
        this.bulkChangeSpaceService = bulkChangeSpaceService;
        this.spaceHelper = spaceHelper;
        this.spaceSettingsCache = spaceSettingsCache;
        this.cqlSearchService = cqlSearchService;
        this.transactionTemplate = transactionTemplate;
        this.classificationService = classificationService;
        this.sensitiveDataScanTaskFactory = sensitiveDataScanTaskFactory;
    }

    public TaskRunnable getTask(ConfluenceUser user, TaskJson taskJson) {
        switch (taskJson.getTaskType()) {
            case BULK_CHANGE_SPACE: {
                return new BulkChangeSpaceTask(this.taskDBService, taskJson.getId(), taskJson.getParamsJson(), this.bulkChangeSpaceService, this.transactionTemplate, user, this.spaceHelper, this.spaceSettingsCache);
            }
            case BULK_CHANGE_CQL: {
                return new BulkChangeCQLTask(this.taskDBService, taskJson.getId(), taskJson.getParamsJson(), user, this.transactionTemplate, this.classificationService, this.cqlSearchService);
            }
            case SENSITIVE_DATA_SCAN: {
                return this.sensitiveDataScanTaskFactory.createSensitiveDataScanTask(taskJson, user);
            }
            case EXCLUSIVE_TEST: {
                return new ExclusiveTestTask(this.taskDBService, taskJson.getId(), user, this.transactionTemplate);
            }
            case PARALLEL_TEST: {
                return new ParallelTestTask(this.taskDBService, taskJson.getId(), user, this.transactionTemplate);
            }
        }
        return null;
    }
}

