/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.task;

import co.uk.automationconsultants.compliance.exception.task.TaskCancellationException;
import co.uk.automationconsultants.compliance.exception.task.TaskPingException;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.service.task.TaskNotificationService;
import co.uk.automationconsultants.compliance.task.TaskRunnable;
import co.uk.automationconsultants.compliance.task.tasks.TaskFactory;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="taskExecutor")
public class TaskExecutor {
    private TaskRunnable runningTask;
    private final TaskFactory taskFactory;
    private final UserAccessor userAccessor;
    private final TaskDBService taskDBService;
    private final ExecutorService executorService;
    private final TransactionTemplate transactionTemplate;
    private static final String COMPLIANCE_TASK_CLUSTER_EXECUTION = "COMPLIANCE_TASK_EXECUTION";
    private final ClusterLockService clusterLockService;
    private final TaskNotificationService taskNotificationService;
    private static final Logger logger = LoggerFactory.getLogger(TaskExecutor.class);

    @Inject
    public TaskExecutor(TaskDBService taskDBService, TaskFactory taskFactory, UserAccessor userAccessor, TransactionTemplate transactionTemplate, ClusterLockService clusterLockService, TaskNotificationService taskNotificationService) {
        this.taskDBService = taskDBService;
        this.taskFactory = taskFactory;
        this.userAccessor = userAccessor;
        this.transactionTemplate = transactionTemplate;
        this.clusterLockService = clusterLockService;
        this.taskNotificationService = taskNotificationService;
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public void submitTask(TaskJson task) {
        ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(task.getCreator()));
        TaskRunnable taskRunnable = this.taskFactory.getTask(user, task);
        this.executorService.submit(() -> {
            if (task.isExclusiveExecution()) {
                this.runExclusiveTask(taskRunnable);
            } else {
                this.runNonExclusiveTask(taskRunnable);
            }
            try {
                this.taskNotificationService.alertAllNodes();
            }
            catch (TaskPingException | IOException e) {
                logger.error("An error occurred while alerting the node {}", (Object)e.getMessage());
            }
        });
    }

    public boolean isReady() {
        return !this.executorService.isShutdown() && !this.executorService.isTerminated();
    }

    public TaskJson getRunningTask() {
        if (this.runningTask != null) {
            return (TaskJson)this.transactionTemplate.execute(() -> this.taskDBService.getTask(this.runningTask.getTaskId()));
        }
        return null;
    }

    public void cancelTaskWithId(int taskId) throws TaskCancellationException {
        if (this.runningTask != null && this.runningTask.getTaskId() == taskId) {
            this.cancelCurrentTask();
        }
    }

    public void cancelCurrentTask() throws TaskCancellationException {
        block4: {
            if (this.runningTask != null && !this.runningTask.isCancelled()) {
                this.runningTask.cancel();
                try {
                    CompletableFuture.runAsync(() -> {
                        do {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        } while (this.runningTask != null && !this.runningTask.isCancelled());
                    }).get(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (this.runningTask.isCancelled()) break block4;
                    this.runningTask.kill();
                    throw new TaskCancellationException();
                }
            }
        }
        this.runningTask = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExclusiveTask(TaskRunnable taskRunnable) {
        ClusterLock clusterLock = this.clusterLockService.getLockForName(COMPLIANCE_TASK_CLUSTER_EXECUTION);
        try {
            if (!clusterLock.tryLock(30L, TimeUnit.MINUTES)) {
                logger.error("Failed to acquire execution lock");
                return;
            }
            this.runningTask = taskRunnable;
            taskRunnable.runTask();
            this.runningTask = null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            clusterLock.unlock();
        }
    }

    private void runNonExclusiveTask(TaskRunnable taskRunnable) {
        this.runningTask = taskRunnable;
        taskRunnable.runTask();
        this.runningTask = null;
    }
}

