/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service.task;

import co.uk.automationconsultants.compliance.exception.task.InvalidParamsException;
import co.uk.automationconsultants.compliance.exception.task.InvalidTaskTypeException;
import co.uk.automationconsultants.compliance.exception.task.NoSuchTaskException;
import co.uk.automationconsultants.compliance.json.task.LogLevelEnum;
import co.uk.automationconsultants.compliance.json.task.TaskCreationJson;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.TaskLogJson;
import co.uk.automationconsultants.compliance.json.task.TaskStatusEnum;
import co.uk.automationconsultants.compliance.json.task.TaskTypeEnum;
import co.uk.automationconsultants.compliance.json.task.search.TaskSearchFilterJson;
import co.uk.automationconsultants.compliance.search.SearchResponse;
import co.uk.automationconsultants.compliance.service.task.TaskFunction;
import com.atlassian.annotations.Internal;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.java.ao.Query;

public interface TaskDBService {
    public TaskJson addTask(TaskCreationJson var1, String var2, String var3) throws InvalidTaskTypeException, InvalidParamsException;

    @Nullable
    public TaskJson getTask(int var1);

    public void cancelTask(int var1);

    public TaskJson updateTask(@Nonnull TaskJson var1) throws NoSuchTaskException, IllegalArgumentException;

    @Internal
    public TaskJson updateTaskNoVerification(@Nonnull TaskJson var1) throws NoSuchTaskException;

    public void killTask(int var1);

    public TaskLogJson addTaskLog(int var1, LogLevelEnum var2, String var3);

    public TaskLogJson addTaskLog(int var1, LogLevelEnum var2, String var3, Long var4, Long var5, String var6);

    public SearchResponse<TaskLogJson> searchTaskLogs(int var1, int var2) throws NoSuchTaskException;

    public SearchResponse<TaskLogJson> searchTaskLogs(int var1, int var2, boolean var3) throws NoSuchTaskException;

    public SearchResponse<TaskLogJson> searchTaskLogs(int var1, int var2, boolean var3, boolean var4) throws NoSuchTaskException;

    public SearchResponse<TaskLogJson> searchTaskLogs(int var1, int var2, String var3, List<String> var4, boolean var5, boolean var6) throws NoSuchTaskException;

    public SearchResponse<TaskJson> searchTasks(int var1, String var2, TaskSearchFilterJson var3, boolean var4);

    public void executeForTasks(TaskSearchFilterJson var1, TaskFunction var2);

    public List<TaskJson> getAllTasksByStatuses(TaskStatusEnum ... var1);

    default public List<TaskJson> getAllUnfinishedTasks() {
        return this.getAllTasksByStatuses(TaskStatusEnum.PENDING, TaskStatusEnum.DELEGATED, TaskStatusEnum.READY_TO_EXECUTE, TaskStatusEnum.IN_PROGRESS);
    }

    public TaskJson getLastSuccessfulTaskOfType(TaskTypeEnum var1);

    public void terminateRunningTasks(String var1);

    public void incrementSuccessValue(int var1, int var2);

    public void incrementFailedValue(int var1, int var2);

    public void incrementWarningValue(int var1, int var2);

    public void updateTotalCount(int var1, int var2);

    public void updateSkipped(int var1);

    public List<TaskJson> runQueryOnTaskTable(Query var1);

    @Internal
    public TaskJson updateLastStatusChange(int var1, Date var2);
}

