/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.listener;

import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.task.TaskManager;
import co.uk.automationconsultants.compliance.task.event.AllNodesNotificationEvent;
import co.uk.automationconsultants.compliance.task.event.SingleNodeNotificationEvent;
import co.uk.automationconsultants.compliance.utils.TaskClusterUtils;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.event.Event;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Named
public class TaskListener
implements DisposableBean {
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final ClusterManager clusterManager;
    private final TaskDBService taskDBService;
    private final TaskManager taskManager;
    private static final Logger logger = LoggerFactory.getLogger(TaskListener.class);

    @Inject
    public TaskListener(EventPublisher eventPublisher, TransactionTemplate transactionTemplate, ClusterManager clusterManager, TaskDBService taskDBService, TaskManager taskManager) {
        this.eventPublisher = eventPublisher;
        this.transactionTemplate = transactionTemplate;
        this.clusterManager = clusterManager;
        this.taskDBService = taskDBService;
        this.taskManager = taskManager;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void pluginFrameWorkStartedEvent(PluginFrameworkStartedEvent event) {
        String clusterId = TaskClusterUtils.getClusterId(this.clusterManager);
        logger.info("Terminating Running tasks for Node {}.", (Object)clusterId);
        this.transactionTemplate.execute(() -> {
            this.taskDBService.terminateRunningTasks(clusterId);
            return null;
        });
    }

    @EventListener
    public void clusterEventWrapper(ClusterEventWrapper clusterEventWrapper) {
        String clusterId = TaskClusterUtils.getClusterId(this.clusterManager);
        logger.debug("Cluster event was received on node {}", (Object)clusterId);
        Event event = clusterEventWrapper.getEvent();
        if (event instanceof SingleNodeNotificationEvent) {
            logger.debug("{} - Cluster event was for single node", (Object)clusterId);
            logger.debug("Id received from event - {}", (Object)((SingleNodeNotificationEvent)event).getElectedNodeId());
            if (clusterId.equals(((SingleNodeNotificationEvent)event).getElectedNodeId())) {
                logger.debug("Task running on node {}", (Object)clusterId);
                this.taskManager.notifyTaskScanner();
            }
        } else if (event instanceof AllNodesNotificationEvent) {
            logger.debug("{} - Cluster event was for all nodes", (Object)clusterId);
            this.taskManager.notifyTaskScanner();
        } else {
            logger.debug("{} - Failed to understand event", (Object)clusterId);
        }
    }

    @EventListener
    public void singleNodeNotificationEvent(SingleNodeNotificationEvent event) {
        String clusterId = TaskClusterUtils.getClusterId(this.clusterManager);
        logger.debug("Single Node Notification event was received on node {}", (Object)clusterId);
        if (clusterId.equals(event.getElectedNodeId())) {
            logger.debug("Task running on node {}", (Object)clusterId);
            this.taskManager.notifyTaskScanner();
        }
    }

    @EventListener
    public void allNodesNotificationEvent(AllNodesNotificationEvent allNodesNotificationEvent) {
        logger.debug("Task Notification event was received on node {}", (Object)TaskClusterUtils.getClusterId(this.clusterManager));
        this.taskManager.notifyTaskScanner();
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

