/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.task.tasks;

import co.uk.automationconsultants.compliance.entity.extractions.ExtractionEntity;
import co.uk.automationconsultants.compliance.exception.task.TaskExecutionException;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIConfigReadOnly;
import co.uk.automationconsultants.compliance.json.scope.ScopeBaseJson;
import co.uk.automationconsultants.compliance.json.settings.ScanSettings;
import co.uk.automationconsultants.compliance.json.task.LogLevelEnum;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.TaskTypeEnum;
import co.uk.automationconsultants.compliance.json.task.params.SensitiveDataScanParams;
import co.uk.automationconsultants.compliance.service.AnalysisService;
import co.uk.automationconsultants.compliance.service.ExtractionService;
import co.uk.automationconsultants.compliance.service.ScopeService;
import co.uk.automationconsultants.compliance.service.externalapi.ExternalAPIService;
import co.uk.automationconsultants.compliance.service.settings.SettingsService;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.task.TaskRunnable;
import co.uk.automationconsultants.compliance.utils.StringUtils;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.google.gson.Gson;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class SensitiveDataScanTask
extends TaskRunnable {
    private final SettingsService settingsService;
    private final UserAccessor userAccessor;
    private final PermissionManager permissionManager;
    private final ScopeService scopeService;
    private final CQLSearchService cqlSearchService;
    private final PageManager pageManager;
    private final AnalysisService analysisService;
    private final ExtractionService extractionService;
    private final ExternalAPIService externalAPIService;

    protected SensitiveDataScanTask(TaskDBService taskDBService, int taskId, String paramsJson, ConfluenceUser actingUser, TransactionTemplate transactionTemplate, SettingsService settingsService, UserAccessor userAccessor, PermissionManager permissionManager, ScopeService scopeService, CQLSearchService cqlSearchService, PageManager pageManager, AnalysisService analysisService, ExtractionService extractionService, ExternalAPIService externalAPIService) {
        super(taskDBService, taskId, paramsJson, actingUser, transactionTemplate);
        this.settingsService = settingsService;
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.scopeService = scopeService;
        this.cqlSearchService = cqlSearchService;
        this.pageManager = pageManager;
        this.analysisService = analysisService;
        this.extractionService = extractionService;
        this.externalAPIService = externalAPIService;
    }

    @Override
    public void execute() throws InterruptedException, TaskExecutionException {
        ScanSettings scanSettings = (ScanSettings)this.transactionTemplate.execute(this.settingsService::getScanSettings);
        if (scanSettings == null) {
            throw new TaskExecutionException("No Settings. Not Running Sensitive Data Scan.");
        }
        SensitiveDataScanParams params = (SensitiveDataScanParams)new Gson().fromJson(this.getParamsJson(), SensitiveDataScanParams.class);
        if (!params.isManual() && Boolean.FALSE.equals(scanSettings.getScheduled())) {
            throw new TaskExecutionException("Scheduled Scan Disabled, Not Running");
        }
        ConfluenceUser user = this.userAccessor.getUserByName(scanSettings.getActingUser());
        if (user == null) {
            throw new TaskExecutionException("Acting User Not Valid. Skipping");
        }
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            throw new TaskExecutionException("Acting User Not Confluence Admin. Not Running.");
        }
        ExternalAPIConfigReadOnly externalAPIConfig = (ExternalAPIConfigReadOnly)this.transactionTemplate.execute(this.externalAPIService::getAuthConfigReadOnly);
        if (externalAPIConfig != null && externalAPIConfig.isEnabled()) {
            try {
                this.externalAPIService.sendExternalAPIOptionsRequest(externalAPIConfig);
            }
            catch (Exception e) {
                this.addErrorLog(e.getMessage());
                throw new TaskExecutionException("Initial request to External API failed. Not Running.");
            }
        }
        AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
        this.addTaskLog(LogLevelEnum.INFO, "Starting scheduled analysis");
        ScopeBaseJson scope = (ScopeBaseJson)this.transactionTemplate.execute(this.scopeService::getScope);
        this.processSpaces(scope, scanSettings.getOnlyScanNewOrEdited() == null ? false : scanSettings.getOnlyScanNewOrEdited(), this.getStartOfLastScan(), scope, (ExtractionEntity[])this.transactionTemplate.execute(this.extractionService::getEnabledExtractions), params.isManual());
        this.settingsService.setLastScheduledScan(new Date());
        this.addTaskLog(LogLevelEnum.INFO, this.isCancelled() ? "Cancelled scheduled analysis" : "Finished scheduled analysis");
    }

    private void processSpaces(ScopeBaseJson scope, boolean onlyScanNewOrEdited, @Nonnull Date lastScan, @Nonnull ScopeBaseJson scopeBaseJson, ExtractionEntity[] enabledExtractions, boolean isAutomated) throws TaskExecutionException {
        if (scope.isDisabled()) {
            this.addTaskLog(LogLevelEnum.INFO, "Scan is disabled. skipping...");
            return;
        }
        String lastScanString = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(lastScan);
        this.addTaskLog(LogLevelEnum.INFO, "Last Scan Date was " + lastScanString);
        List<String> queries = this.getCQLQueries(scope, onlyScanNewOrEdited, lastScanString);
        int totalCount = this.getTotalCount(queries);
        this.updateTotalCount(totalCount);
        for (int i = 0; i < queries.size(); ++i) {
            this.handleCQLQuery(queries.get(i), scopeBaseJson, enabledExtractions, isAutomated, i + 1, queries.size());
        }
    }

    private void handleCQLQuery(String cql, ScopeBaseJson scope, ExtractionEntity[] enabledExtractions, boolean isAutomated, int queryNo, int querySize) throws TaskExecutionException {
        int totalCount = this.getTotalCount(cql);
        int noOfBatches = (int)Math.ceil((double)totalCount / 200.0);
        this.addTaskLog(LogLevelEnum.INFO, String.format("Processing Query %d/%d, batches = %d", queryNo, querySize, noOfBatches));
        boolean isMore = true;
        int startAt = 0;
        int batchNo = 1;
        while (isMore && !this.isCancelled()) {
            PageResponse pageResponse = this.cqlSearchService.searchContent(cql, (PageRequest)new SimplePageRequest(startAt, 200), new Expansion[0]);
            List pages = pageResponse.getResults();
            if (!pages.isEmpty()) {
                this.addTaskLog(LogLevelEnum.INFO, String.format("Query %d: Processing batch %d of %d", queryNo, batchNo, noOfBatches));
            }
            int[] counts = this.handlePages(pages, isAutomated, scope, enabledExtractions);
            ++batchNo;
            this.updateProgress(pages.size(), counts[0], counts[1], this.isCancelled());
            isMore = pageResponse.hasMore();
            startAt += 200;
            if (pages.isEmpty() || counts[0] != 0 || counts[1] != 0) continue;
            throw new TaskExecutionException("Failed to successfully scan any pages in previous batch. Ending scan.");
        }
    }

    private int[] handlePages(List<Content> pages, boolean isAutomated, ScopeBaseJson scope, ExtractionEntity[] enabledExtractions) {
        int successCount = 0;
        int warningCount = 0;
        for (Content result : pages) {
            if (this.isCancelled()) break;
            long pageId = result.getId().asLong();
            Page page = this.pageManager.getPage(pageId);
            if (page != null) {
                try {
                    this.analysisService.processPage(page, "scheduled", isAutomated, scope, true, enabledExtractions);
                    ++successCount;
                }
                catch (Exception e) {
                    this.addTaskLog(LogLevelEnum.ERROR, e.getMessage(), page.getId(), page.getSpace().getId(), page.getSpaceKey());
                }
                continue;
            }
            this.addTaskLog(LogLevelEnum.WARNING, String.format("Page %d could not be found", pageId));
            ++warningCount;
        }
        return new int[]{successCount, warningCount};
    }

    private void updateProgress(int batchSize, int successCount, int warning, boolean cancelled) {
        this.transactionTemplate.execute(() -> {
            this.taskDBService.incrementSuccessValue(this.taskId, successCount);
            this.taskDBService.incrementWarningValue(this.taskId, warning);
            if (!cancelled) {
                this.taskDBService.incrementFailedValue(this.taskId, batchSize - successCount - warning);
            } else {
                this.taskDBService.updateSkipped(this.taskId);
            }
            return null;
        });
    }

    private Date getStartOfLastScan() {
        return (Date)this.transactionTemplate.execute(() -> {
            TaskJson lastScanTask = this.taskDBService.getLastSuccessfulTaskOfType(TaskTypeEnum.SENSITIVE_DATA_SCAN);
            return lastScanTask == null ? new Date(0L) : lastScanTask.getTimeStarted();
        });
    }

    private int getTotalCount(List<String> cqlQueries) {
        return cqlQueries.stream().reduce(0, (acc, query) -> acc + this.cqlSearchService.countContent(query), Integer::sum);
    }

    private int getTotalCount(String query) {
        return this.cqlSearchService.countContent(query);
    }

    private List<String> getSpaceQueries(List<String> spaceKeys, boolean onlyScanNewOrEdited, String lastScanString) {
        int end;
        StringBuilder queryFormatBuilder = new StringBuilder();
        queryFormatBuilder.append("type = page");
        if (onlyScanNewOrEdited) {
            queryFormatBuilder.append(" AND (content.property[classificationanalysis].constant != 1");
            queryFormatBuilder.append(String.format(" OR lastmodified >= '%s')", lastScanString));
        }
        queryFormatBuilder.append(" AND space IN %s");
        queryFormatBuilder.append(" ORDER BY id");
        String queryFormat = queryFormatBuilder.toString();
        ArrayList<String> queries = new ArrayList<String>();
        for (int index = 0; index < spaceKeys.size(); index += end) {
            end = Math.min(index + 1024, spaceKeys.size());
            List<String> subList = spaceKeys.subList(index, end);
            String query = String.format(queryFormat, StringUtils.generateCommaSepListWrappedInBrackets(subList));
            queries.add(query);
        }
        return queries;
    }

    private List<String> getCQLQueries(ScopeBaseJson scope, boolean onlyScanNewOrEdited, String lastScanString) {
        switch (scope.getState()) {
            case SPACE: {
                List<String> spaceKeys = scope.getSpaces().stream().map(String::toUpperCase).collect(Collectors.toList());
                return this.getSpaceQueries(spaceKeys, onlyScanNewOrEdited, lastScanString);
            }
            case ENABLED: {
                StringBuilder queryBuilder = new StringBuilder();
                queryBuilder.append("type = page");
                if (onlyScanNewOrEdited) {
                    queryBuilder.append(" AND (content.property[classificationanalysis].constant != 1");
                    queryBuilder.append(String.format(" OR lastmodified >= '%s')", lastScanString));
                }
                queryBuilder.append(" ORDER BY id");
                String query = queryBuilder.toString();
                return Collections.singletonList(query);
            }
        }
        return new ArrayList<String>();
    }
}

