/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.cache.GlobalSettingsCache;
import co.uk.automationconsultants.compliance.json.request.SearchRequestJson;
import co.uk.automationconsultants.compliance.service.SensitiveSearchService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.user.User;
import java.util.Collections;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/search")
public class SensitiveDataSearchRest {
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final SpacePermissionManager spacePermissionManager;
    @ComponentImport
    private final SpaceManager spaceManager;
    private final GlobalSettingsCache globalSettingsCache;
    private final SensitiveSearchService sensitiveSearchService;

    @Inject
    public SensitiveDataSearchRest(SensitiveSearchService sensitiveSearchService, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, SpaceManager spaceManager, GlobalSettingsCache globalSettingsCache) {
        this.sensitiveSearchService = sensitiveSearchService;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.spacePermissionManager = spacePermissionManager;
        this.spaceManager = spaceManager;
        this.globalSettingsCache = globalSettingsCache;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response searchAsUser(@Context HttpServletRequest request, SearchRequestJson searchRequestJson, @QueryParam(value="spaceKey") String spaceKey) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        Space space = this.spaceManager.getSpace(spaceKey);
        if (user == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (space == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, (User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok((Object)this.sensitiveSearchService.searchSensitiveData(Collections.singletonList(spaceKey), searchRequestJson.getExtractions(), searchRequestJson.getStartAt(), searchRequestJson.getLimit(), searchRequestJson.getQuery().equals("") ? null : searchRequestJson.getQuery())).build();
    }

    @POST
    @WebSudoRequired
    @Path(value="/admin")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response searchAsAdmin(@Context HttpServletRequest request, SearchRequestJson searchRequestJson) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok((Object)this.sensitiveSearchService.searchSensitiveData(searchRequestJson.getSpaces(), searchRequestJson.getExtractions(), searchRequestJson.getStartAt(), searchRequestJson.getLimit(), searchRequestJson.getQuery().equals("") ? null : searchRequestJson.getQuery())).build();
    }
}

