/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.utils.task;

import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.utils.DateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaskMaintenanceUtils {
    private TaskMaintenanceUtils() {
    }

    private static boolean isRelatedToNodes(Set<String> nodes, TaskJson task) {
        return nodes.contains(task.getElectedNode()) || nodes.contains(task.getManagerNode());
    }

    public static boolean isTaskTimedOut(Set<String> deadNodeIds, TaskJson task) {
        return TaskMaintenanceUtils.isRelatedToNodes(deadNodeIds, task) && DateUtils.longerSince(task.getLastStatusChange().getTime(), 120000L);
    }

    private static boolean isTaskReadyToRun(TaskJson task, Map<String, List<TaskJson>> runningTasksPerNode, boolean topOfQueue, boolean allTasksAboveAreParallel) {
        if (topOfQueue) {
            return task.isExclusiveExecution() ? runningTasksPerNode.isEmpty() : ((List)runningTasksPerNode.getOrDefault(task.getElectedNode(), new ArrayList())).isEmpty();
        }
        return !task.isExclusiveExecution() && allTasksAboveAreParallel;
    }

    public static Set<String> getNodeIdsFromTasks(List<TaskJson> tasks) {
        return tasks.stream().map(task -> Arrays.asList(task.getElectedNode(), task.getManagerNode())).reduce(new HashSet(), (acc, partialResults) -> {
            acc.addAll(partialResults);
            return acc;
        }, (set1, set2) -> {
            set1.addAll(set2);
            return set1;
        });
    }

    public static boolean shouldBeCheckedOnAliveNodes(Set<String> aliveNodeIds, TaskJson task, Map<String, List<TaskJson>> runningTasksPerNode, boolean topOfQueue, boolean allTasksAboveAreParallel) {
        return TaskMaintenanceUtils.isRelatedToNodes(aliveNodeIds, task) && (task.isRunning() || TaskMaintenanceUtils.isTaskReadyToRun(task, runningTasksPerNode, topOfQueue, allTasksAboveAreParallel));
    }
}

