/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service;

import co.uk.automationconsultants.compliance.entity.SettingEntity;
import co.uk.automationconsultants.compliance.entity.analysis.ExtractionResult;
import co.uk.automationconsultants.compliance.entity.extractions.ExtractionEntity;
import co.uk.automationconsultants.compliance.json.analysis.AnalysisTrackerJson;
import co.uk.automationconsultants.compliance.json.scope.ScopeBaseJson;
import co.uk.automationconsultants.compliance.json.scope.ScopeEnum;
import co.uk.automationconsultants.compliance.json.settings.StatusJson;
import co.uk.automationconsultants.compliance.service.ExtractionService;
import co.uk.automationconsultants.compliance.service.LogService;
import co.uk.automationconsultants.compliance.service.ScopeService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.atlassian.plugins.rest.common.json.JsonMarshallingException;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.user.User;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="analysisService")
public class AnalysisService {
    private static final String ANALYSIS_LOCK_NAME = AnalysisService.class.getName() + ".analysisTask";
    public static final String ANALYSIS_CP_KEY = "classificationanalysis";
    private static final Logger log = LoggerFactory.getLogger(AnalysisService.class);
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final ContentPropertyService contentPropertyService;
    @ComponentImport
    private final ContentService contentService;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final JaxbJsonMarshaller jaxbJsonMarshaller;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final CQLSearchService cqlSearchService;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final ClusterLockService clusterLockService;
    @ComponentImport
    private final PermissionManager permissionManager;
    private final LogService logService;
    private final ExtractionService extractionService;
    private final ScopeService scopeService;

    @Inject
    public AnalysisService(ActiveObjects activeObjects, SpaceManager spaceManager, ContentPropertyService contentPropertyService, ContentService contentService, PageManager pageManager, JaxbJsonMarshaller jaxbJsonMarshaller, TransactionTemplate transactionTemplate, CQLSearchService cqlSearchService, UserAccessor userAccessor, ClusterLockService clusterLockService, PermissionManager permissionManager, LogService logService, ExtractionService extractionService, ScopeService scopeService) {
        this.activeObjects = activeObjects;
        this.spaceManager = spaceManager;
        this.contentPropertyService = contentPropertyService;
        this.contentService = contentService;
        this.pageManager = pageManager;
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
        this.transactionTemplate = transactionTemplate;
        this.cqlSearchService = cqlSearchService;
        this.userAccessor = userAccessor;
        this.clusterLockService = clusterLockService;
        this.permissionManager = permissionManager;
        this.logService = logService;
        this.extractionService = extractionService;
        this.scopeService = scopeService;
    }

    public void processPageRealTime(Page page, boolean isAutomatedAction) {
        SettingEntity[] settings = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
        if (settings.length != 0 && Boolean.TRUE.equals(settings[0].getRealTimeScan())) {
            this.processPage(page, "realTime", isAutomatedAction, this.scopeService.getScope(), Boolean.TRUE.equals(settings[0].getRealTimeScanPrevVersions()), this.extractionService.getEnabledExtractions());
        }
    }

    public void processPage(Page page, String origin, boolean isAutomatedAction, ScopeBaseJson scope, boolean scanPreviousVersions, ExtractionEntity[] enabledExtractions) {
        if (page.getSpace() != null && this.scopeService.inScope(page.getSpace(), scope)) {
            this.clearPreviousResults((AbstractPage)page);
            this.transactionTemplate.execute(() -> {
                if (scanPreviousVersions) {
                    for (int version = 1; version < page.getLatestVersion().getVersion(); ++version) {
                        AbstractPage pageByVersion = this.pageManager.getPageByVersion((AbstractPage)page, version);
                        if (pageByVersion != null) {
                            this.extractionService.handlePageExtractions(page.getId(), pageByVersion, page.getSpace(), enabledExtractions, origin, isAutomatedAction);
                            continue;
                        }
                        log.error("Error getting Page {} for Version {}", (Object)page.getId(), (Object)version);
                    }
                }
                this.extractionService.handlePageExtractions(page.getId(), (AbstractPage)page, page.getSpace(), enabledExtractions, origin, isAutomatedAction);
                this.setLatestAnalysedPage((AbstractPage)page);
                return true;
            });
        }
    }

    public JobRunnerResponse processMaintenanceScan() {
        this.logService.addScanLog(AuthenticatedUserThreadLocal.getUsername(), "Maintenance: Deleting Entries", "init");
        this.activeObjects.executeInTransaction(() -> this.activeObjects.deleteWithSQL(ExtractionResult.class, "ID > 0", new Object[0]));
        this.logService.addScanLog(AuthenticatedUserThreadLocal.getUsername(), "Maintenance: Deleting Content Properties", "init");
        boolean isMore = true;
        int startAt = 0;
        while (isMore) {
            PageResponse results = this.cqlSearchService.searchContent("type = page", (PageRequest)new SimplePageRequest(startAt, 200), new Expansion[0]);
            for (Content result : results.getResults()) {
                this.transactionTemplate.execute(() -> {
                    JsonContentProperty versionCp;
                    Content content = (Content)this.contentService.find(new Expansion[0]).withId(result.getId()).fetchOrNull();
                    if (content != null && (versionCp = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(result.getId()).withPropertyKey(ANALYSIS_CP_KEY).fetchOrNull()) != null) {
                        this.contentPropertyService.delete(versionCp);
                    }
                    return true;
                });
            }
            isMore = results.hasMore();
        }
        this.setLastScheduledScan(null);
        this.logService.addScanLog(AuthenticatedUserThreadLocal.getUsername(), "Maintenance: Running Scan", "init");
        return this.processScheduledScan(true);
    }

    public JobRunnerResponse processScheduledScan(boolean manual) {
        return (JobRunnerResponse)this.transactionTemplate.execute(() -> {
            ClusterLock lock = this.clusterLockService.getLockForName(ANALYSIS_LOCK_NAME);
            if (lock.tryLock()) {
                try {
                    SettingEntity[] settings = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
                    if (settings.length == 0) {
                        JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success((String)"No Settings. Not Running Scheduled Scan.");
                        return jobRunnerResponse;
                    }
                    if (!manual && Boolean.FALSE.equals(settings[0].getScheduledScan())) {
                        JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success((String)"Scheduled Scan Disabled. Not Running.");
                        return jobRunnerResponse;
                    }
                    ConfluenceUser user = this.userAccessor.getUserByName(settings[0].getActingUser());
                    if (user == null) {
                        JobRunnerResponse jobRunnerResponse = JobRunnerResponse.failed((String)"Acting User Not Valid. Not Running.");
                        return jobRunnerResponse;
                    }
                    if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
                        JobRunnerResponse jobRunnerResponse = JobRunnerResponse.failed((String)"Acting User Not Confluence Admin. Not Running.");
                        return jobRunnerResponse;
                    }
                    AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
                    log.debug("Starting Scheduled Scan...");
                    this.logService.addScanLog(AuthenticatedUserThreadLocal.getUsername(), "Starting Scheduled Analysis", "init");
                    ScopeBaseJson scope = this.scopeService.getScope();
                    StatusJson status = this.scopeService.getStatus(scope);
                    this.processSpaces(this.getSpaceKeysForScan(scope), status.getTotal() != status.getScanned(), settings[0].getLastScheduledScan() == null ? new Date(0L) : settings[0].getLastScheduledScan(), scope, this.extractionService.getEnabledExtractions(), false);
                    log.debug("Finished Scheduled Scan!");
                    this.setLastScheduledScan(new Date());
                    this.logService.addScanLog(AuthenticatedUserThreadLocal.getUsername(), "Finished Scheduled Analysis", "end");
                    JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success((String)"Scheduled Scan Completed");
                    return jobRunnerResponse;
                }
                catch (Exception e) {
                    log.debug("Error occurred during attempted Scheduled Sensitive Data Analysis");
                    this.logService.addScanLog(AuthenticatedUserThreadLocal.getUsername(), "Scan Failed: " + e.getMessage(), "error");
                    JobRunnerResponse jobRunnerResponse = JobRunnerResponse.failed((String)e.getMessage());
                    return jobRunnerResponse;
                }
                finally {
                    AuthenticatedUserThreadLocal.reset();
                    lock.unlock();
                }
            }
            return JobRunnerResponse.failed((String)"Scan has already been started by another thread");
        });
    }

    public List<String> getSpaceKeysForScan(ScopeBaseJson scope) {
        if (scope.getState() == ScopeEnum.ENABLED) {
            return this.spaceManager.getAllSpaces().stream().map(Space::getKey).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (scope.getState() == ScopeEnum.SPACE) {
            return scope.getSpaces();
        }
        return new ArrayList<String>();
    }

    private void processSpaces(List<String> spaces, boolean scanAll, @Nonnull Date lastScan, @Nonnull ScopeBaseJson scopeBaseJson, ExtractionEntity[] enabledExtractions, boolean isAutomated) {
        String lastScanString = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(lastScan);
        log.debug("Last Scan Date was {}", (Object)lastScanString);
        int current = 1;
        for (String space : spaces) {
            String cql = scanAll ? String.format("type = page AND space = \"%s\"", space) : String.format("type = page AND space = \"%s\" AND lastmodified >= \"%s\"", space.toUpperCase(), lastScanString);
            log.debug("Scanning Space {}", (Object)space);
            this.logService.addScanLog(AuthenticatedUserThreadLocal.getUsername(), "Scanning Space " + space + " (" + current + "/" + spaces.size() + ")...", "scan");
            boolean isMore = true;
            int startAt = 0;
            while (isMore) {
                log.debug("Page {}", (Object)startAt);
                PageResponse results = this.cqlSearchService.searchContent(cql, (PageRequest)new SimplePageRequest(startAt, 200), new Expansion[0]);
                this.logService.addScanLog(AuthenticatedUserThreadLocal.getUsername(), "Processing " + results.size() + (scanAll ? " (All)" : "") + " pages in " + space, "scan");
                for (Content result : results.getResults()) {
                    Page page = this.pageManager.getPage(result.getId().asLong());
                    if (page == null) continue;
                    this.processPage(page, "scheduled", isAutomated, scopeBaseJson, true, enabledExtractions);
                }
                isMore = results.hasMore();
                startAt += 200;
            }
            ++current;
        }
    }

    private void setLastScheduledScan(Date date) {
        this.activeObjects.executeInTransaction(() -> {
            SettingEntity[] settings = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
            if (settings.length != 0) {
                settings[0].setLastScheduledScan(date);
                settings[0].save();
            }
            return null;
        });
    }

    private void clearPreviousResults(AbstractPage page) {
        this.activeObjects.executeInTransaction(() -> {
            for (ExtractionResult extractionResult : (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, "PAGE_ID = ? AND PAGE_VERSION < ? AND SPACE_ID = ? AND ACTIVE = ?", new Object[]{page.getId(), page.getLatestVersion().getVersion(), page.getSpace().getId(), true})) {
                extractionResult.setActive(false);
                extractionResult.save();
            }
            return true;
        });
    }

    private void setLatestAnalysedPage(AbstractPage page) {
        this.transactionTemplate.execute(() -> {
            Content content = (Content)this.contentService.find(new Expansion[0]).withId(page.getContentId()).fetchOrNull();
            if (content != null) {
                JsonContentProperty versionCp = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(page.getContentId()).withPropertyKey(ANALYSIS_CP_KEY).fetchOrNull();
                String analysisJson = this.getAnalysisJsonString(new AnalysisTrackerJson(new Date(), page.getLatestVersion().getVersion()));
                JsonContentProperty.ContentPropertyBuilder property = JsonContentProperty.builder().content(content).key(ANALYSIS_CP_KEY).value(new JsonString(analysisJson));
                try {
                    if (versionCp != null) {
                        JsonContentProperty newCp = property.version(Objects.requireNonNull(versionCp.getVersion()).nextBuilder().build()).build();
                        ValidationResult validationResult = this.contentPropertyService.validator().validateUpdate(newCp);
                        if (validationResult.isValid() && validationResult.isAuthorized()) {
                            this.contentPropertyService.update(newCp);
                            log.debug("Updated Content Property: {}", (Object)newCp.getValue().getValue());
                        } else {
                            log.debug("Failed to Update Content Property: {}", (Object)newCp.getValue().getValue());
                            validationResult.getErrors().forEach(e -> log.debug(e.getMessage().getTranslation()));
                        }
                    } else {
                        JsonContentProperty newCp = property.build();
                        ValidationResult validationResult = this.contentPropertyService.validator().validateCreate(newCp);
                        if (validationResult.isValid() && validationResult.isAuthorized()) {
                            this.contentPropertyService.create(newCp);
                            log.debug("Created Content Property: {}", (Object)newCp.getValue().getValue());
                        } else {
                            log.debug("Failed to Create Content Property: {}", (Object)newCp.getValue().getValue());
                            validationResult.getErrors().forEach(e -> log.debug(e.getMessage().getTranslation()));
                        }
                    }
                }
                catch (ServiceException e2) {
                    log.error("Service Exception while setting Latest Analysed Version: {}", (Object)e2.toString());
                }
            }
            return null;
        });
    }

    private String getAnalysisJsonString(AnalysisTrackerJson json) {
        try {
            return this.jaxbJsonMarshaller.marshal((Object)json);
        }
        catch (JsonMarshallingException e) {
            log.error("Error Marshalling Analysis Tracker JSON - {}", (Object)e.getMessage());
            return null;
        }
    }

    public void onDeletePage(Page page) {
        this.activeObjects.executeInTransaction(() -> this.activeObjects.deleteWithSQL(ExtractionResult.class, "PAGE_ID = ?", new Object[]{page.getLatestVersion().getId()}));
    }

    public void onTrashPage(Page page) {
        this.activeObjects.executeInTransaction(() -> this.activeObjects.deleteWithSQL(ExtractionResult.class, "PAGE_ID = ?", new Object[]{page.getLatestVersion().getId()}));
    }

    public void onRestorePage(Page page) {
        this.processPageRealTime(page, true);
    }

    public StatusJson getStatus() {
        return this.scopeService.getStatus();
    }
}

