/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service.externalapi;

import co.uk.automationconsultants.compliance.entity.externalapi.GlobalKeyPair;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;

@Scanned
@Named
public class GlobalKeyPairService {
    @ComponentImport
    private final ActiveObjects activeObjects;
    private static final String ALGORITHM = "RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING";

    @Inject
    public GlobalKeyPairService(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public KeyPair getKeyPair() throws NoSuchAlgorithmException, InvalidKeySpecException {
        GlobalKeyPair[] globalKeyPair = (GlobalKeyPair[])this.activeObjects.find(GlobalKeyPair.class);
        if (globalKeyPair.length == 0) {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            KeyPair pair = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = pair.getPrivate();
            PublicKey publicKey = pair.getPublic();
            String privateKeyEncoded = Base64.getEncoder().encodeToString(privateKey.getEncoded());
            String publicKeyEncoded = Base64.getEncoder().encodeToString(publicKey.getEncoded());
            this.activeObjects.create(GlobalKeyPair.class, new DBParam[]{new DBParam("PRIVATE_KEY", (Object)privateKeyEncoded), new DBParam("PUBLIC_KEY", (Object)publicKeyEncoded)});
            return pair;
        }
        KeyFactory kf = KeyFactory.getInstance("RSA");
        String privateKeyEncoded = globalKeyPair[0].getPrivateKey();
        PKCS8EncodedKeySpec keySpecPKCS8 = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKeyEncoded));
        PrivateKey privateKey = kf.generatePrivate(keySpecPKCS8);
        String publicKeyEncoded = globalKeyPair[0].getPublicKey();
        X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyEncoded));
        PublicKey publicKey = kf.generatePublic(keySpecX509);
        return new KeyPair(publicKey, privateKey);
    }

    public String[] encryptUsernameAndToken(KeyPair keyPair, String username, String token) throws GeneralSecurityException {
        Cipher encryptCipher = Cipher.getInstance(ALGORITHM);
        encryptCipher.init(1, keyPair.getPublic());
        String encryptedUsername = null;
        if (username != null) {
            byte[] usernameBytes = username.getBytes(StandardCharsets.UTF_8);
            encryptedUsername = Base64.getEncoder().encodeToString(encryptCipher.doFinal(usernameBytes));
        }
        String encryptedToken = null;
        if (token != null) {
            byte[] tokenBytes = token.getBytes(StandardCharsets.UTF_8);
            encryptedToken = Base64.getEncoder().encodeToString(encryptCipher.doFinal(tokenBytes));
        }
        return new String[]{encryptedUsername, encryptedToken};
    }

    public String decryptString(KeyPair keyPair, String cipherText) throws GeneralSecurityException {
        if (cipherText == null) {
            return null;
        }
        Cipher decryptCipher = Cipher.getInstance(ALGORITHM);
        decryptCipher.init(2, keyPair.getPrivate());
        byte[] decryptedMessageBytes = decryptCipher.doFinal(Base64.getDecoder().decode(cipherText));
        return new String(decryptedMessageBytes, StandardCharsets.UTF_8);
    }
}

