/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.json.level.BulkChangeRequest;
import co.uk.automationconsultants.compliance.json.level.LevelJson;
import co.uk.automationconsultants.compliance.json.request.VerificationResult;
import co.uk.automationconsultants.compliance.json.settings.GlobalSettingsJson;
import co.uk.automationconsultants.compliance.json.settings.SpaceSettingsPropertyJson;
import co.uk.automationconsultants.compliance.service.ClassificationService;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
@Path(value="/bulk")
public class BulkChangeRest {
    public static final int RESULTS_LIMIT = 200;
    private static final Logger log = LoggerFactory.getLogger(BulkChangeRest.class);
    @ComponentImport
    private final CQLSearchService cqlSearchService;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    private final ClassificationService classificationService;
    @ComponentImport
    private final EntityManagerProvider entityManagerProvider;

    @Inject
    public BulkChangeRest(CQLSearchService cqlSearchService, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, ClassificationService classificationService, EntityManagerProvider entityManagerProvider) {
        this.cqlSearchService = cqlSearchService;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.classificationService = classificationService;
        this.entityManagerProvider = entityManagerProvider;
    }

    @POST
    @Path(value="/validate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response validateRequest(@Context HttpServletRequest context, BulkChangeRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(context)).getUserKey());
        request.setCql("type = page AND " + request.getCql());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            int count = this.cqlSearchService.countContent(request.getCql());
            return Response.ok((Object)new VerificationResult(true, "", count)).build();
        }
        catch (Exception e) {
            return Response.ok((Object)new VerificationResult(false, e.getMessage(), 0)).build();
        }
    }

    @POST
    @Path(value="/execute")
    @Consumes(value={"application/json"})
    public Response executeRequest(@Context HttpServletRequest context, BulkChangeRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(context)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        request.setCql("type = page AND " + request.getCql() + " ORDER BY id");
        GlobalSettingsJson settings = this.classificationService.getSettings();
        List<LevelJson> levels = this.classificationService.getLevels();
        boolean isMore = true;
        int startAt = 0;
        log.debug("Compliance for Confluence - Bulk Change: Starting Bulk Change");
        while (isMore) {
            PageResponse results = this.cqlSearchService.searchContent(request.getCql(), (PageRequest)new SimplePageRequest(startAt, 200), new Expansion[]{Expansion.combine((Object[])new Object[]{"space"})});
            log.debug("Compliance for Confluence - Bulk Change: Number of pages to classify - " + results.size() + ". Are there more: " + results.hasMore());
            for (Content result : results.getResults()) {
                log.debug("Compliance for Confluence - Bulk Change: Classifying \"" + result.getTitle() + "\"");
                long id = result.getId().asLong();
                String key = ((Space)result.getSpaceRef().get()).getKey();
                SpaceSettingsPropertyJson spaceSettings = this.classificationService.getSpaceSettings(key);
                this.classificationService.performClassification(id, (User)user, request.getLevel(), spaceSettings, levels, settings, false);
            }
            isMore = results.hasMore();
            startAt += 200;
            this.entityManagerProvider.getEntityManager().clear();
        }
        log.debug("Compliance for Confluence - Bulk Change: Completed");
        return Response.ok().build();
    }
}

