/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.task.tasks;

import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.service.AnalysisService;
import co.uk.automationconsultants.compliance.service.ExtractionService;
import co.uk.automationconsultants.compliance.service.ScopeService;
import co.uk.automationconsultants.compliance.service.externalapi.ExternalAPIService;
import co.uk.automationconsultants.compliance.service.settings.SettingsService;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.task.tasks.SensitiveDataScanTask;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import javax.inject.Inject;
import javax.inject.Named;

@Scanned
@Named
public class SensitiveDataScanTaskFactory {
    private final TaskDBService taskDBService;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private final SettingsService settingsService;
    private final UserAccessor userAccessor;
    private final PermissionManager permissionManager;
    private final ScopeService scopeService;
    @ComponentImport
    private final CQLSearchService cqlSearchService;
    private final PageManager pageManager;
    private final AnalysisService analysisService;
    private final ExtractionService extractionService;
    private final ExternalAPIService externalAPIService;

    @Inject
    public SensitiveDataScanTaskFactory(TaskDBService taskDBService, TransactionTemplate transactionTemplate, SettingsService settingsService, UserAccessor userAccessor, PermissionManager permissionManager, ScopeService scopeService, CQLSearchService cqlSearchService, PageManager pageManager, AnalysisService analysisService, ExtractionService extractionService, ExternalAPIService externalAPIService) {
        this.taskDBService = taskDBService;
        this.transactionTemplate = transactionTemplate;
        this.settingsService = settingsService;
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.scopeService = scopeService;
        this.cqlSearchService = cqlSearchService;
        this.pageManager = pageManager;
        this.analysisService = analysisService;
        this.extractionService = extractionService;
        this.externalAPIService = externalAPIService;
    }

    public SensitiveDataScanTask createSensitiveDataScanTask(TaskJson task, ConfluenceUser user) {
        return new SensitiveDataScanTask(this.taskDBService, task.getId(), task.getParamsJson(), user, this.transactionTemplate, this.settingsService, this.userAccessor, this.permissionManager, this.scopeService, this.cqlSearchService, this.pageManager, this.analysisService, this.extractionService, this.externalAPIService);
    }
}

