/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service;

import co.uk.automationconsultants.compliance.entity.analysis.ExtractionResult;
import co.uk.automationconsultants.compliance.entity.automation.ActionInstance;
import co.uk.automationconsultants.compliance.json.analysis.AnalysisResultJson;
import co.uk.automationconsultants.compliance.json.analysis.SearchResultJson;
import co.uk.automationconsultants.compliance.json.request.AdHocChangeRequestJson;
import co.uk.automationconsultants.compliance.service.LogService;
import co.uk.automationconsultants.compliance.service.SensitiveSearchService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.IndexManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

@Scanned
@Named(value="automationService")
public class AutomationService {
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final IndexManager indexManager;
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private final LogService logService;
    private final SensitiveSearchService sensitiveSearchService;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final SettingsManager settingsManager;

    @Inject
    public AutomationService(PageManager pageManager, IndexManager indexManager, SensitiveSearchService sensitiveSearchService, ActiveObjects activeObjects, TransactionTemplate transactionTemplate, LogService logService, SpaceManager spaceManager, SettingsManager settingsManager) {
        this.pageManager = pageManager;
        this.indexManager = indexManager;
        this.sensitiveSearchService = sensitiveSearchService;
        this.activeObjects = activeObjects;
        this.transactionTemplate = transactionTemplate;
        this.logService = logService;
        this.spaceManager = spaceManager;
        this.settingsManager = settingsManager;
    }

    public void redactSelectedItems(boolean automatic, ConfluenceUser user, List<Integer> items) {
        for (Integer item : items) {
            if (item == null) continue;
            ExtractionResult entity = (ExtractionResult)this.activeObjects.get(ExtractionResult.class, (Object)item);
            ExtractionResult[] matchingItems = (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, Query.select().where("PAGE_ID = ? AND CAPTURED_TEXT = ?", new Object[]{entity.getPageId(), entity.getCapturedText()}));
            ActionInstance created = (ActionInstance)this.activeObjects.create(ActionInstance.class, new DBParam[]{new DBParam("DATE", (Object)new Date()), new DBParam("EXTRACTION_RESULT_ID", (Object)matchingItems[0].getID()), new DBParam("ACTION_LABEL", null), new DBParam("ACTION_LEVEL", null), new DBParam("ACTION_TYPE", (Object)"REDACT"), new DBParam("ACTION_USER", null), new DBParam("AUTOMATIC", (Object)automatic), new DBParam("PAGE_ID", (Object)entity.getPageId()), new DBParam("USER", (Object)user.getName())});
            if (this.redactPage(entity.getPageId(), entity.getCapturedText(), created.getID()).booleanValue()) {
                for (ExtractionResult res : matchingItems) {
                    res.setActive(false);
                    res.save();
                }
                continue;
            }
            this.activeObjects.delete(new RawEntity[]{created});
        }
    }

    public void redactAllItems(boolean automatic, ConfluenceUser user, AdHocChangeRequestJson changeRequestJson) {
        SearchResultJson results = this.sensitiveSearchService.searchSensitiveData(changeRequestJson.getSpaces(), changeRequestJson.getExtractions(), 0, 1000, changeRequestJson.getQuery());
        for (AnalysisResultJson result : results.getResults()) {
            ExtractionResult entity = (ExtractionResult)this.activeObjects.get(ExtractionResult.class, (Object)result.getId());
            ExtractionResult[] matchingItems = (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, Query.select().where("PAGE_ID = ? AND CAPTURED_TEXT = ?", new Object[]{entity.getPageId(), entity.getCapturedText()}));
            ActionInstance created = (ActionInstance)this.activeObjects.create(ActionInstance.class, new DBParam[]{new DBParam("DATE", (Object)new Date()), new DBParam("EXTRACTION_RESULT_ID", (Object)matchingItems[0].getID()), new DBParam("ACTION_LABEL", null), new DBParam("ACTION_LEVEL", null), new DBParam("ACTION_TYPE", (Object)"REDACT"), new DBParam("ACTION_USER", null), new DBParam("AUTOMATIC", (Object)automatic), new DBParam("PAGE_ID", (Object)entity.getPageId()), new DBParam("USER", (Object)user.getName())});
            if (this.redactPage(entity.getPageId(), entity.getCapturedText(), created.getID()).booleanValue()) {
                for (ExtractionResult res : matchingItems) {
                    res.setActive(false);
                    res.save();
                }
                continue;
            }
            this.activeObjects.delete(new RawEntity[]{created});
        }
    }

    private Boolean confirmRedact(Long pageId, String text) {
        Page page = this.pageManager.getPage(pageId.longValue());
        if (page != null) {
            page = page.getLatestVersion();
            for (int i = page.getVersion(); i >= 1; --i) {
                String body;
                Page ceo = (Page)this.pageManager.getPageByVersion((AbstractPage)page, i);
                if (ceo == null || !(body = ceo.getBodyAsString()).contains(text)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Boolean redactPage(Long pageId, String text, Integer actionLogId) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            Page page = this.pageManager.getPage(pageId.longValue());
            if (page != null) {
                page = page.getLatestVersion();
                for (int i = page.getVersion(); i >= 1; --i) {
                    Page ceo = (Page)this.pageManager.getPageByVersion((AbstractPage)page, i);
                    if (ceo == null) continue;
                    String body = ceo.getBodyAsString();
                    String regex = "(<[^>]*\"[^>]*)(" + text + ")([^>]*\"[^>]*>)";
                    String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
                    baseUrl = baseUrl + "/plugins/servlet/server-classification/audit?page=action&amp;id=" + actionLogId;
                    body = body.replaceAll(regex, "$1\u2588$3");
                    ceo.setBodyAsString(body.replaceAll(text, "<a title=\"This text has been redacted using Compliance for Confluence. The ID of this redact is " + actionLogId + ". Click here to find out more.\" href=\"" + baseUrl + "\">" + new String(new char[text.length()]).replace("\u0000", "\u2588") + "</a>"));
                    if (i == 1) {
                        ceo.setPosition(Integer.valueOf(0));
                    }
                    DefaultSaveContext saveContext = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)new DefaultSaveContext.Builder().suppressNotifications(false)).suppressAutowatch(true).suppressEvents(true)).build();
                    this.pageManager.saveContentEntity((ContentEntityObject)ceo, (SaveContext)saveContext);
                }
            }
            return this.confirmRedact(pageId, text);
        });
    }
}

