/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service.maintenance;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.pages.Page;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
@Named(value="contentPropertyMaintenanceService")
public class ContentPropertyMaintenanceService {
    @ComponentImport
    private final ContentPropertyService contentPropertyService;
    @ComponentImport
    private final ContentService contentService;
    private static final Logger log = LoggerFactory.getLogger(ContentPropertyMaintenanceService.class);

    @Inject
    public ContentPropertyMaintenanceService(ContentPropertyService contentPropertyService, ContentService contentService) {
        this.contentPropertyService = contentPropertyService;
        this.contentService = contentService;
    }

    public void reAddContentProperty(String propertyKey, Page page) {
        JsonContentProperty jsonContentProperty = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(page.getContentId()).withPropertyKey(propertyKey).fetchOrNull();
        if (jsonContentProperty != null) {
            JsonString jsonString = jsonContentProperty.getValue();
            ValidationResult validationResult = this.contentPropertyService.validator().validateDelete(jsonContentProperty);
            if (validationResult.isSuccessful()) {
                this.contentPropertyService.delete(jsonContentProperty);
                Content content = (Content)this.contentService.find(new Expansion[0]).withId(page.getContentId()).fetchOrNull();
                JsonContentProperty newContentProperty = JsonContentProperty.builder().content(content).key(propertyKey).value(jsonString).build();
                this.contentPropertyService.create(newContentProperty);
            } else {
                log.error("Failed to delete old content property");
            }
        }
    }

    public void reAddComplianceContentProperties(Page page) {
        for (String propertyKey : Arrays.asList("classificationhistory", "classification", "classificationanalysis")) {
            this.reAddContentProperty(propertyKey, page);
        }
        for (Page child : page.getChildren()) {
            this.reAddComplianceContentProperties(child);
        }
    }
}

