/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service;

import co.uk.automationconsultants.compliance.json.level.LevelRestrictionJson;
import co.uk.automationconsultants.compliance.json.settings.SpaceSettingsPropertyJson;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.JsonSpaceProperty;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.SpacePropertyService;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.atlassian.plugins.rest.common.json.JsonMarshallingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import javax.inject.Named;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
@Named(value="bulkChangeSpaceService")
public class BulkChangeSpaceService {
    private static final Logger log = LoggerFactory.getLogger(BulkChangeSpaceService.class);
    @ComponentImport
    private final SpacePropertyService spacePropertyService;
    @ComponentImport
    private final JaxbJsonMarshaller jaxbJsonMarshaller;

    public BulkChangeSpaceService(SpacePropertyService spacePropertyService, JaxbJsonMarshaller jaxbJsonMarshaller) {
        this.spacePropertyService = spacePropertyService;
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
    }

    public void modifySpaceSettings(String spaceKey, boolean action, String type) throws IOException {
        JsonSpaceProperty settings = (JsonSpaceProperty)this.spacePropertyService.find(new Expansion[]{new Expansion("version")}).withSpaceKey(spaceKey).withPropertyKey("dataclassification").fetchOrNull();
        if (settings == null) {
            settings = this.createDefaultSpaceSettingsProperty(spaceKey);
        }
        if (settings == null) {
            throw new NullPointerException("Unable to get/create space content property");
        }
        ObjectMapper mapper = new ObjectMapper();
        SpaceSettingsPropertyJson spaceJson = (SpaceSettingsPropertyJson)mapper.readValue(settings.getValue().getValue(), SpaceSettingsPropertyJson.class);
        SpaceSettingsPropertyJson newJson = new SpaceSettingsPropertyJson(spaceJson.enabled, spaceJson.restricted, spaceJson.force, spaceJson.levelRestrictions, spaceJson.constantGroups);
        switch (type) {
            case "force": {
                newJson.setForce(action);
                break;
            }
            case "enabled": {
                newJson.setEnabled(action);
                break;
            }
        }
        String spaceSettingsJson = this.getSpaceSettingsJsonString(newJson);
        JsonSpaceProperty property = ((JsonSpaceProperty.SpacePropertyBuilder)((JsonSpaceProperty.SpacePropertyBuilder)((JsonSpaceProperty.SpacePropertyBuilder)JsonSpaceProperty.builder().space(Space.builder().key(spaceKey).build()).key("dataclassification")).value(new JsonString(spaceSettingsJson))).version(Objects.requireNonNull(settings.getVersion()).nextBuilder().build())).build();
        ValidationResult result = this.spacePropertyService.validator().validateUpdate(property);
        if (result.isValid() && result.isAuthorized()) {
            this.spacePropertyService.update(property);
        }
    }

    private JsonSpaceProperty createDefaultSpaceSettingsProperty(String spaceKey) {
        SpaceSettingsPropertyJson defaultJson = new SpaceSettingsPropertyJson(true, false, false, new ArrayList<LevelRestrictionJson>(), new ArrayList<String>());
        String spaceSettingsJsonString = this.getSpaceSettingsJsonString(defaultJson);
        JsonSpaceProperty property = this.buildSpaceProperty(spaceKey, spaceSettingsJsonString);
        return this.createSpaceProperty(property);
    }

    private String getSpaceSettingsJsonString(SpaceSettingsPropertyJson json) {
        try {
            return this.jaxbJsonMarshaller.marshal((Object)json);
        }
        catch (JsonMarshallingException e) {
            log.error("Error Marshalling Analysis Tracker JSON - " + e.getMessage());
            return null;
        }
    }

    private JsonSpaceProperty buildSpaceProperty(String spaceKey, String spaceSettingsJson) {
        return ((JsonSpaceProperty.SpacePropertyBuilder)((JsonSpaceProperty.SpacePropertyBuilder)((JsonSpaceProperty.SpacePropertyBuilder)JsonSpaceProperty.builder().space(Space.builder().key(spaceKey).build()).key("dataclassification")).value(new JsonString(spaceSettingsJson))).version(Version.builder().number(1).build())).build();
    }

    private JsonSpaceProperty createSpaceProperty(JsonSpaceProperty propertyToCreate) {
        ValidationResult result = this.spacePropertyService.validator().validateCreate(propertyToCreate);
        if (result.isValid() && result.isAuthorized()) {
            return this.spacePropertyService.create(propertyToCreate);
        }
        return null;
    }
}

