/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service;

import co.uk.automationconsultants.compliance.service.ExtractionService;
import co.uk.automationconsultants.compliance.service.enumerator.LicenseType;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
@Named(value="complianceLicenseService")
public class ComplianceLicenseService {
    private static final Logger log = LoggerFactory.getLogger(ExtractionService.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private final LicenseService licenseService;

    @Inject
    public ComplianceLicenseService(PluginLicenseManager pluginLicenseManager, LicenseService licenseService) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.licenseService = licenseService;
    }

    private DateTime getReleaseDate() throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("properties-from-pom.properties");
        Properties properties = new Properties();
        properties.load(is);
        String releaseDate = properties.getProperty("timestamp");
        String timestampFormat = properties.getProperty("maven.build.timestamp.format");
        return DateTimeFormat.forPattern((String)timestampFormat).parseDateTime(releaseDate);
    }

    private boolean validateExpiredLicense(PluginLicense license) {
        if (!license.isEvaluation() && !license.isDataCenter()) {
            try {
                DateTime licenseExpiryDate = (DateTime)license.getMaintenanceExpiryDate().get();
                DateTime pluginReleaseDate = this.getReleaseDate();
                return pluginReleaseDate.isBefore((ReadableInstant)licenseExpiryDate);
            }
            catch (IOException e) {
                log.error("Failed to get release date", (Throwable)e);
            }
        }
        return false;
    }

    public LicenseType getLicense() {
        if (!this.pluginLicenseManager.getLicense().isDefined()) {
            return LicenseType.NO_LICENSE;
        }
        PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
        boolean isConfluenceDCLicensed = this.licenseService.isLicensedForDataCenter();
        boolean isPluginDCLicensed = pluginLicense.isDataCenter();
        if (pluginLicense.getError().isDefined()) {
            if (((LicenseError)pluginLicense.getError().get()).equals((Object)LicenseError.EXPIRED) && !isConfluenceDCLicensed && !isPluginDCLicensed && pluginLicense.isMaintenanceExpired() && this.validateExpiredLicense(pluginLicense)) {
                return LicenseType.FULL_LICENSE;
            }
            return LicenseType.NO_LICENSE;
        }
        if (isConfluenceDCLicensed == isPluginDCLicensed && pluginLicense.isValid()) {
            return pluginLicense.isEvaluation() ? LicenseType.EVAL_LICENSE : LicenseType.FULL_LICENSE;
        }
        return LicenseType.NO_LICENSE;
    }
}

