/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.scheduler.task;

import co.uk.automationconsultants.compliance.exception.task.NoSuchTaskException;
import co.uk.automationconsultants.compliance.exception.task.TaskCancellationException;
import co.uk.automationconsultants.compliance.exception.task.TaskPingException;
import co.uk.automationconsultants.compliance.helper.ClusterHelper;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.TaskStatusEnum;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.service.task.TaskNotificationService;
import co.uk.automationconsultants.compliance.task.TaskManager;
import co.uk.automationconsultants.compliance.task.delegation.TaskDelegationService;
import co.uk.automationconsultants.compliance.task.maintenance.TaskMaintenanceParams;
import co.uk.automationconsultants.compliance.task.maintenance.TaskMaintenanceParamsFactory;
import co.uk.automationconsultants.compliance.utils.DateUtils;
import co.uk.automationconsultants.compliance.utils.task.TaskDBServiceUtils;
import co.uk.automationconsultants.compliance.utils.task.TaskMaintenanceUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
@Named
public class TaskMaintenanceJobRunner
implements JobRunner {
    private final ClusterHelper clusterHelper;
    private final TaskDBService taskDBService;
    private final TaskDelegationService taskDelegationService;
    private final TaskNotificationService taskNotificationService;
    private final TaskManager taskManager;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private static final long TASK_TIMEOUT = 600000L;
    private static final Logger logger = LoggerFactory.getLogger(TaskMaintenanceJobRunner.class);

    @Inject
    public TaskMaintenanceJobRunner(ClusterHelper clusterHelper, TaskDBService taskDBService, TaskDelegationService taskDelegationService, TaskNotificationService taskNotificationService, TaskManager taskManager, TransactionTemplate transactionTemplate) {
        this.clusterHelper = clusterHelper;
        this.taskDBService = taskDBService;
        this.taskDelegationService = taskDelegationService;
        this.taskNotificationService = taskNotificationService;
        this.taskManager = taskManager;
        this.transactionTemplate = transactionTemplate;
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        logger.info("Task Manager Maintenance scan about to begin");
        this.performMaintenanceScan();
        logger.info("Task Manager Maintenance scan has completed");
        return JobRunnerResponse.success((String)"Task Manager Maintenance Scan has completed");
    }

    public void performMaintenanceScan() {
        String currentNodeId = this.clusterHelper.getCurrentNodeId();
        logger.debug("Current Node ID: {}", (Object)currentNodeId);
        if (currentNodeId == null) {
            logger.info("Unclustered system. Skipping Maintenance scan");
            return;
        }
        List unfinishedTasks = (List)this.transactionTemplate.execute(this.taskDBService::getAllUnfinishedTasks);
        logger.debug("Gotten {} unfinished tasks", (Object)unfinishedTasks.size());
        if (unfinishedTasks.isEmpty()) {
            return;
        }
        TaskMaintenanceParams maintenanceParams = TaskMaintenanceParamsFactory.initialiseMaintenanceParams(currentNodeId, this.taskDBService, unfinishedTasks, this.clusterHelper, this.transactionTemplate);
        TaskJson firstTask = (TaskJson)unfinishedTasks.remove(0);
        this.performTaskMaintenance(firstTask, maintenanceParams, true, true);
        boolean allTasksAboveAreParallel = !firstTask.isExclusiveExecution();
        for (TaskJson task : unfinishedTasks) {
            this.performTaskMaintenance(task, maintenanceParams, false, allTasksAboveAreParallel);
            allTasksAboveAreParallel &= !task.isExclusiveExecution();
        }
    }

    private void performTaskMaintenance(TaskJson task, TaskMaintenanceParams taskMaintenanceParams, boolean topOfQueue, boolean allTasksAboveAreParallel) {
        try {
            if (TaskMaintenanceUtils.isTaskTimedOut(taskMaintenanceParams.getDeadNodeIds(), task)) {
                logger.debug("Task {} timed out on dead node", (Object)task.getId());
                this.handleDeadTask(task, taskMaintenanceParams.getCurrentNodeId(), taskMaintenanceParams.getDeadNodeIds());
            } else if (TaskMaintenanceUtils.shouldBeCheckedOnAliveNodes(taskMaintenanceParams.getAliveNodeIds(), task, taskMaintenanceParams.getRunningTasksPerNode(), topOfQueue, allTasksAboveAreParallel)) {
                logger.debug("Task {} should be checked on alive node", (Object)task.getId());
                this.handleAliveNode(task, taskMaintenanceParams.getHowLongItHasBeenMap(), taskMaintenanceParams.getCurrentNodeId());
            }
        }
        catch (Exception e) {
            logger.error("An error occurred while handling task {} on node {} during task maintenance. error: {}", new Object[]{task.getId(), taskMaintenanceParams.getCurrentNodeId(), e.getMessage()});
        }
    }

    private void handleAliveNode(TaskJson task, Map<String, Date> howLongHasItBeenMap, String currNodeId) throws TaskPingException, IOException, TaskCancellationException {
        long lastStatusChange = task.getLastStatusChange().getTime();
        if (task.isRunning()) {
            this.handleRunningAliveTask(task, currNodeId, lastStatusChange);
        } else {
            this.handleNotRunningAliveTask(task, howLongHasItBeenMap, currNodeId, lastStatusChange);
        }
    }

    private void handleNotRunningAliveTask(TaskJson task, Map<String, Date> howLongHasItBeenMap, String currNodeId, long lastStatusChange) {
        Optional<Date> howLongHasItBeen = this.getHowLongItHasBeen(task, howLongHasItBeenMap);
        long delta = howLongHasItBeen.map(date -> Math.max(date.getTime(), lastStatusChange)).orElse(lastStatusChange);
        if (task.isManagedByNode(currNodeId)) {
            if (DateUtils.longerSince(delta, 600000L)) {
                logger.debug("Task {} to be re-delegated", (Object)task.getId());
                this.transactionTemplate.execute(() -> {
                    try {
                        this.taskDelegationService.delegateTask(task.getId());
                    }
                    catch (NoSuchTaskException | IOException e) {
                        logger.error("Non-running alive task {} could not be redelegated. error: {}", (Object)task.getId(), (Object)e.getMessage());
                    }
                    return null;
                });
            }
        } else if (DateUtils.longerSince(delta, 600000L, 2)) {
            logger.debug("Assign Node {} as manager in task {}", (Object)currNodeId, (Object)task.getId());
            this.assignNodeAsManagerInTransaction(task.getId(), currNodeId);
        }
    }

    private void handleRunningAliveTask(TaskJson task, String currNodeId, long lastStatusChange) throws IOException, TaskPingException, TaskCancellationException {
        if (task.isManagedByNode(currNodeId)) {
            boolean shouldTerminateTask;
            boolean taskTimedOut = DateUtils.longerSince(lastStatusChange, 600000L);
            boolean bl = shouldTerminateTask = !this.taskNotificationService.isExecutorBusy(task.getElectedNode()) || DateUtils.longerSince(lastStatusChange, 600000L, 2);
            if (taskTimedOut && shouldTerminateTask) {
                logger.debug("Task {} taking too long on node {}. cancelling task...", (Object)task.getId(), (Object)task.getElectedNode());
                this.taskManager.cancelTask(task.getId());
            }
        } else if (DateUtils.longerSince(lastStatusChange, 600000L, 3)) {
            logger.debug("Task {} to be assigned on node {}", (Object)task.getId(), (Object)currNodeId);
            this.assignNodeAsManagerInTransaction(task.getId(), currNodeId);
        }
    }

    private void handleDeadTask(TaskJson task, @Nullable String currentNodeId, Set<String> deadNodeIds) {
        if (task.isManagedByNode(currentNodeId)) {
            this.manageDeadTask(task);
        } else if (deadNodeIds.contains(task.getManagerNode())) {
            this.assignNodeAsManagerInTransaction(task.getId(), currentNodeId);
        }
    }

    private void assignNodeAsManagerInTransaction(int taskId, String currentNodeId) {
        this.transactionTemplate.execute(() -> {
            try {
                TaskDBServiceUtils.assignNodeAsManager(this.taskDBService, taskId, currentNodeId);
            }
            catch (NoSuchTaskException e) {
                logger.error("Failed to assign node {} as manager to task {}. error: {}", new Object[]{currentNodeId, taskId, e.getMessage()});
            }
            return null;
        });
    }

    private void manageDeadTask(TaskJson task) {
        this.transactionTemplate.execute(() -> {
            if (task.getStatus().equals((Object)TaskStatusEnum.IN_PROGRESS)) {
                logger.debug("Task {} was running on dead node. to be terminated", (Object)task.getId());
                this.taskDBService.killTask(task.getId());
            } else {
                try {
                    logger.debug("Task {} to be re-delegated", (Object)task.getId());
                    this.taskDelegationService.delegateTask(task.getId());
                }
                catch (NoSuchTaskException | IOException e) {
                    logger.error("Dead task {} could not be redelegated. error: {}", (Object)task.getId(), (Object)e.getMessage());
                }
            }
            return null;
        });
    }

    private Optional<Date> getHowLongItHasBeen(TaskJson task, Map<String, Date> howLongItHasBeenMap) {
        if (task.isExclusiveExecution()) {
            return howLongItHasBeenMap.values().stream().max(Comparator.comparingLong(Date::getTime));
        }
        return Optional.ofNullable(howLongItHasBeenMap.get(task.getElectedNode()));
    }
}

