/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.json.settings.GlobalSettingsJson;
import co.uk.automationconsultants.compliance.json.settings.SpaceSettingsPropertyJson;
import co.uk.automationconsultants.compliance.service.ClassificationService;
import com.atlassian.confluence.api.service.content.SpacePropertyService;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
@Path(value="/classify")
public class ClassifyRest {
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final SpacePropertyService spacePropertyService;
    private final ClassificationService classificationService;
    private static final Logger log = LoggerFactory.getLogger(ClassifyRest.class);

    @Inject
    public ClassifyRest(PageManager pageManager, PermissionManager permissionManager, UserManager userManager, UserAccessor userAccessor, ClassificationService classificationService, SpacePropertyService spacePropertyService) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.classificationService = classificationService;
        this.spacePropertyService = spacePropertyService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response classifyPage(@Context HttpServletRequest request, @QueryParam(value="pid") long pid, @QueryParam(value="lid") int lid) {
        boolean notGloballyControlledAndUnrestricted;
        boolean spaceRestricted;
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        Page page = this.pageManager.getPage(pid);
        if (user == null) {
            return Response.status((int)403).build();
        }
        if (page == null) {
            return Response.status((int)404).build();
        }
        if (!this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)page)) {
            return Response.status((int)403).build();
        }
        SpaceSettingsPropertyJson spaceSettingsPropertyJson = this.classificationService.getSpaceSettings(page.getSpaceKey());
        GlobalSettingsJson globalSettings = this.classificationService.getSettings();
        boolean restrictGloballyControlled = Boolean.TRUE.equals(globalSettings.getRestrictGloballyControlled());
        boolean isGloballyRestricted = Boolean.TRUE.equals(globalSettings.getRestrict());
        boolean isClassificationInherited = Boolean.TRUE.equals(globalSettings.getInherit());
        boolean userHasSetPermissionRight = this.canUserSetPermission(globalSettings, user, page, pid);
        boolean bl = spaceRestricted = spaceSettingsPropertyJson != null;
        if (spaceRestricted) {
            spaceRestricted = spaceSettingsPropertyJson.isRestricted();
        }
        boolean notSpaceRestricted = spaceSettingsPropertyJson == null || !spaceSettingsPropertyJson.restricted;
        boolean globalWithRestrictions = restrictGloballyControlled && isGloballyRestricted;
        boolean hasPermissionsWithGlobalRestrictions = globalWithRestrictions && userHasSetPermissionRight;
        boolean globalControllNoRestrictions = restrictGloballyControlled && !isGloballyRestricted;
        boolean notGlobalSpacePermitted = !restrictGloballyControlled && spaceRestricted && userHasSetPermissionRight;
        boolean bl2 = notGloballyControlledAndUnrestricted = !restrictGloballyControlled && notSpaceRestricted;
        if (hasPermissionsWithGlobalRestrictions || globalControllNoRestrictions || notGlobalSpacePermitted || notGloballyControlledAndUnrestricted) {
            log.debug("{} - The user has the correct permissions, attempting to classify page...", (Object)pid);
            long startTime = System.currentTimeMillis();
            boolean result = this.classificationService.performClassification(pid, (User)user, lid, spaceSettingsPropertyJson, this.classificationService.getLevels(), globalSettings, false);
            log.debug("{} - Page has been classified. Time taken: {}.ms ", (Object)pid, (Object)(System.currentTimeMillis() - startTime));
            if (result) {
                if (isClassificationInherited) {
                    log.debug("{} - Inherit Classification enabled. Classifying child pages", (Object)pid);
                    List children = page.getChildren();
                    if (children.isEmpty()) {
                        log.debug("{} - No child pages found. Skipping...", (Object)pid);
                    }
                    for (Page child : page.getChildren()) {
                        log.debug("{} - Classifying child page {} ", (Object)pid, (Object)child.getId());
                        this.classifyPage(request, child.getId(), lid);
                    }
                }
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.status((int)403).build();
    }

    private boolean canUserSetPermission(GlobalSettingsJson globalSettingsJson, ConfluenceUser user, Page page, long pageId) {
        long startTime = System.currentTimeMillis();
        boolean userHasSetPermissionRight = Boolean.TRUE.equals(globalSettingsJson.getOnlyCheckEditPerms()) || this.permissionManager.hasPermission((User)user, Permission.SET_PERMISSIONS, (Object)page);
        log.debug("{} - Permission check completed in classifyPage. Time taken: {}ms ", (Object)pageId, (Object)(System.currentTimeMillis() - startTime));
        return userHasSetPermissionRight;
    }
}

