/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.listener;

import co.uk.automationconsultants.compliance.json.settings.GlobalSettingsJson;
import co.uk.automationconsultants.compliance.service.ClassificationService;
import co.uk.automationconsultants.compliance.service.settings.SettingsService;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Scanned
@Named(value="draftListener")
public class DraftListener
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DraftListener.class);
    @ComponentImport
    private final LabelManager labelManager;
    @ComponentImport
    protected EventPublisher eventPublisher;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final ContentPropertyService contentPropertyService;
    private final SettingsService settingsService;
    private final ClassificationService classificationService;

    @Inject
    public DraftListener(LabelManager labelManager, EventPublisher eventPublisher, PermissionManager permissionManager, ContentPropertyService contentPropertyService, SettingsService settingsService, ClassificationService classificationService) {
        this.labelManager = labelManager;
        this.eventPublisher = eventPublisher;
        this.permissionManager = permissionManager;
        this.contentPropertyService = contentPropertyService;
        this.settingsService = settingsService;
        this.classificationService = classificationService;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void pageCreated(PageCreateEvent event) {
        List labels = event.getContent().getLabels();
        int currentClassification = -1;
        for (Label label : labels) {
            String name = label.getName();
            if (!name.contains("classification-")) continue;
            currentClassification = Integer.parseInt(name.replace("classification-", ""));
            this.labelManager.removeLabel((Labelable)event.getPage(), label);
        }
        JsonContentProperty existingLevel = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(event.getPage().getContentId()).withPropertyKey("classification").fetchOrNull();
        Integer defaultLevel = this.settingsService.getDefaultLevel(event.getPage().getSpaceKey());
        if (currentClassification == -1 && existingLevel == null) {
            currentClassification = defaultLevel;
        }
        long pageId = event.getPage().getId();
        ConfluenceUser creator = event.getPage().getCreator();
        GlobalSettingsJson settings = this.classificationService.getSettings();
        if (currentClassification > -1) {
            log.debug("Compliance for Confluence - Page Listener (" + pageId + ") - Level Found: " + currentClassification + ", will make the page comply.");
            boolean canSetPermissions = false;
            canSetPermissions = Boolean.TRUE.equals(settings.getOnlyCheckEditPerms()) ? this.permissionManager.hasPermission((User)creator, Permission.EDIT, (Object)event.getPage()) : this.permissionManager.hasPermission((User)creator, Permission.SET_PERMISSIONS, (Object)event.getPage());
            if (canSetPermissions) {
                log.debug("Compliance for Confluence - Permissions Check Successful - Classifying Page");
                this.classificationService.performClassification(pageId, (User)creator, currentClassification, this.classificationService.getSpaceSettings(event.getPage().getSpaceKey()), this.classificationService.getLevels(), settings, true);
            } else {
                log.debug("Compliance for Confluence - Insufficient Permissions to Set Classification");
            }
        } else {
            log.debug("Compliance for Confluence - Page Listener (" + pageId + ") - No Level Found, page will not be classified.");
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

