/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service;

import co.uk.automationconsultants.compliance.entity.scope.ScopeEntity;
import co.uk.automationconsultants.compliance.entity.scope.ScopeSpaceEntity;
import co.uk.automationconsultants.compliance.json.scope.ScopeBaseJson;
import co.uk.automationconsultants.compliance.json.scope.ScopeEnum;
import co.uk.automationconsultants.compliance.json.settings.StatusJson;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Named;
import net.java.ao.Query;

@Scanned
@Named(value="scopeService")
public class ScopeService {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final CQLSearchService cqlSearchService;

    public ScopeService(ActiveObjects activeObjects, SpaceManager spaceManager, CQLSearchService cqlSearchService) {
        this.activeObjects = activeObjects;
        this.spaceManager = spaceManager;
        this.cqlSearchService = cqlSearchService;
    }

    public ScopeBaseJson getScope() {
        ScopeEntity[] scope = (ScopeEntity[])this.activeObjects.find(ScopeEntity.class, Query.select().order("ID DESC").limit(1));
        if (scope.length == 0) {
            return new ScopeBaseJson(ScopeEnum.DISABLED);
        }
        switch (scope[0].getScope()) {
            case "enabled": {
                return new ScopeBaseJson(ScopeEnum.ENABLED);
            }
            case "spaces": {
                List<String> spaces = Arrays.stream((ScopeSpaceEntity[])this.activeObjects.find(ScopeSpaceEntity.class)).map(ScopeSpaceEntity::getSpaceKey).filter(spaceKey -> this.spaceManager.getSpace(spaceKey) != null).collect(Collectors.toList());
                return new ScopeBaseJson(ScopeEnum.SPACE, spaces);
            }
        }
        return new ScopeBaseJson(ScopeEnum.DISABLED);
    }

    public StatusJson getStatus() {
        return this.getStatusInternal(null);
    }

    public StatusJson getStatus(ScopeBaseJson scope) {
        return this.getStatusInternal(scope);
    }

    public boolean inScope(Space space, @Nonnull ScopeBaseJson scope) {
        if (scope.getState().equals((Object)ScopeEnum.DISABLED)) {
            return false;
        }
        if (scope.getState().equals((Object)ScopeEnum.SPACE)) {
            return scope.getSpaces().stream().anyMatch(s -> s.equalsIgnoreCase(space.getKey()));
        }
        return true;
    }

    private StatusJson getStatusInternal(ScopeBaseJson scope) {
        if (scope == null) {
            scope = this.getScope();
        }
        if (scope.getState() == ScopeEnum.DISABLED) {
            return new StatusJson(0, 0);
        }
        String query = "type = page";
        if (scope.getState() == ScopeEnum.SPACE) {
            query = query.concat(String.format(" AND space IN ( %s)", scope.getSpaces().stream().map(space -> "\"" + space + "\"").collect(Collectors.joining(","))));
        }
        int total = this.cqlSearchService.countContent(query, SearchContext.builder().build());
        int scanned = this.cqlSearchService.countContent(query.concat(" AND content.property[classificationanalysis].constant = 1"), SearchContext.builder().build());
        return new StatusJson(total, scanned);
    }
}

