/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.cache;

import co.uk.automationconsultants.compliance.json.level.LevelsJson;
import co.uk.automationconsultants.compliance.rest.LevelRest;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;

@Scanned
@Named(value="globalSettingsCache")
public class GlobalSettingsCache {
    @ComponentImport
    private final CacheManager cacheManager;
    private final Cache<String, String> globalSettingsCache;
    @ComponentImport
    private final ActiveObjects activeObjects;

    @Inject
    public GlobalSettingsCache(CacheManager cacheManager, ActiveObjects activeObjects) {
        this.cacheManager = cacheManager;
        this.globalSettingsCache = cacheManager.getCache(GlobalSettingsCache.class.getName() + ".globalCache", (CacheLoader)new GlobalSettingsCached(), new CacheSettingsBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maxEntries(5).build());
        this.activeObjects = activeObjects;
    }

    public LevelsJson getGlobalSettings() {
        Gson gson = new GsonBuilder().serializeNulls().create();
        return (LevelsJson)gson.fromJson((String)this.globalSettingsCache.get((Object)"GLOBAL"), LevelsJson.class);
    }

    public void invalidateCaches() {
        this.globalSettingsCache.removeAll();
    }

    private class GlobalSettingsCached
    implements CacheLoader<String, String> {
        private GlobalSettingsCached() {
        }

        public String load(@Nonnull String systemKey) {
            Gson gson = new GsonBuilder().serializeNulls().create();
            LevelsJson levels = LevelRest.getLevels(GlobalSettingsCache.this.activeObjects);
            String serialized = gson.toJson((Object)levels);
            return serialized;
        }
    }
}

