/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service.settings;

import co.uk.automationconsultants.compliance.entity.SettingEntity;
import co.uk.automationconsultants.compliance.json.settings.ScanSettings;
import co.uk.automationconsultants.compliance.service.settings.SettingsService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Date;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;

@Scanned
@Named
public class SettingsServiceImpl
implements SettingsService {
    @ComponentImport
    private final ActiveObjects activeObjects;

    @Inject
    public SettingsServiceImpl(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    @Override
    @Nullable
    public ScanSettings getScanSettings() {
        SettingEntity[] settingsList = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
        if (settingsList.length == 0) {
            return null;
        }
        SettingEntity settings = settingsList[0];
        return new ScanSettings(settings.getRealTimeScan(), settings.getRealTimeScanPrevVersions(), settings.getScheduledScan(), settings.getActingUser(), settings.getLastScheduledScan());
    }

    @Override
    public void setLastScheduledScan(Date date) {
        this.activeObjects.executeInTransaction(() -> {
            SettingEntity[] settings = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
            if (settings.length != 0) {
                settings[0].setLastScheduledScan(date);
                settings[0].save();
            }
            return null;
        });
    }
}

