/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.helper;

import co.uk.automationconsultants.compliance.helper.ClusterHelper;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.cluster.NodeStatus;
import com.atlassian.confluence.server.ApplicationState;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.util.ReflectionUtils;

@Scanned
@Named(value="clusterHelper")
public class ClusterHelperImpl
implements ClusterHelper {
    @ComponentImport
    private final ClusterManager clusterManager;

    @Inject
    public ClusterHelperImpl(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    @Override
    public List<ClusterNodeInformation> getRunningNodes() {
        return this.filterNodes(entry -> this.isNodeAlive((NodeStatus)entry.getValue()));
    }

    @Override
    public Set<String> getRunningNodeIds() {
        List<ClusterNodeInformation> aliveNodes = this.getRunningNodes();
        return this.getNodeIdsFromNodes(aliveNodes);
    }

    @Override
    @Nullable
    public ClusterNodeInformation getNodeById(String clusterId) {
        List<ClusterNodeInformation> nodes = this.filterNodes(entry -> ((ClusterNodeInformation)entry.getKey()).getAnonymizedNodeIdentifier().equals(clusterId));
        return nodes.isEmpty() ? null : nodes.get(0);
    }

    @Override
    public boolean isNodeAlive(String clusterId) {
        return this.clusterManager.getNodeStatusMap().entrySet().stream().anyMatch(entry -> ((ClusterNodeInformation)entry.getKey()).getAnonymizedNodeIdentifier().equals(clusterId) && this.isNodeAlive((NodeStatus)entry.getValue()));
    }

    @Override
    @Nullable
    public String getCurrentNodeId() {
        ClusterNodeInformation clusterNodeInformation = this.clusterManager.getThisNodeInformation();
        return clusterNodeInformation == null ? null : clusterNodeInformation.getAnonymizedNodeIdentifier();
    }

    private boolean isNodeAlive(NodeStatus status) {
        Method m = ReflectionUtils.findMethod(NodeStatus.class, (String)"getApplicationState");
        if (m == null) {
            return true;
        }
        try {
            return m.invoke((Object)status, new Object[0]).equals(ApplicationState.RUNNING);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return true;
        }
    }

    @Override
    public List<ClusterNodeInformation> getRunningNodes(Set<String> nodeIds) {
        return this.filterNodes(entry -> nodeIds.contains(((ClusterNodeInformation)entry.getKey()).getAnonymizedNodeIdentifier()) && this.isNodeAlive((NodeStatus)entry.getValue()));
    }

    @Override
    public Set<String> getRunningNodeIds(Set<String> nodeIds) {
        List<ClusterNodeInformation> nodes = this.getRunningNodes(nodeIds);
        return this.getNodeIdsFromNodes(nodes);
    }

    @Override
    public List<ClusterNodeInformation> getDeadNodes() {
        return this.filterNodes(entry -> !this.isNodeAlive((NodeStatus)entry.getValue()));
    }

    @Override
    public Set<String> getDeadNodeIds() {
        List<ClusterNodeInformation> nodes = this.getDeadNodes();
        return this.getNodeIdsFromNodes(nodes);
    }

    @Override
    public List<ClusterNodeInformation> getDeadNodes(Set<String> nodeIds) {
        return this.filterNodes(entry -> nodeIds.contains(((ClusterNodeInformation)entry.getKey()).getAnonymizedNodeIdentifier()) && !this.isNodeAlive((NodeStatus)entry.getValue()));
    }

    @Override
    public Set<String> getDeadNodeIds(Set<String> nodeIds) {
        List<ClusterNodeInformation> nodes = this.getDeadNodes(nodeIds);
        Set allNodeIds = this.clusterManager.getAllNodesInformation().stream().map(ClusterNodeInformation::getAnonymizedNodeIdentifier).collect(Collectors.toSet());
        HashSet<String> invalidIds = new HashSet<String>(nodeIds);
        invalidIds.removeAll(allNodeIds);
        invalidIds.addAll(this.getNodeIdsFromNodes(nodes));
        return invalidIds;
    }

    private List<ClusterNodeInformation> filterNodes(Predicate<Map.Entry<ClusterNodeInformation, NodeStatus>> predicate) {
        return this.clusterManager.getNodeStatusMap().entrySet().stream().filter(predicate).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private Set<String> getNodeIdsFromNodes(List<ClusterNodeInformation> nodes) {
        return nodes.stream().map(ClusterNodeInformation::getAnonymizedNodeIdentifier).collect(Collectors.toSet());
    }
}

