/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service;

import co.uk.automationconsultants.compliance.entity.LogEntity;
import co.uk.automationconsultants.compliance.entity.automation.ActionInstance;
import co.uk.automationconsultants.compliance.json.analysis.PageJson;
import co.uk.automationconsultants.compliance.json.settings.ActionLogJson;
import co.uk.automationconsultants.compliance.json.settings.LogJson;
import co.uk.automationconsultants.compliance.json.settings.UserProfileJson;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;

@Scanned
@Named(value="logService")
public class LogService {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final UserAccessor userAccessor;

    @Inject
    public LogService(ActiveObjects activeObjects, PageManager pageManager, UserAccessor userAccessor) {
        this.activeObjects = activeObjects;
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
    }

    public List<LogJson> getLogs(int limit) {
        return Arrays.stream((LogEntity[])this.activeObjects.find(LogEntity.class, Query.select().order("DATE DESC").limit(limit))).map(logEntity -> {
            ConfluenceUser user = this.userAccessor.getUserByName(logEntity.getUser());
            return LogJson.map(logEntity, this.pageManager, new UserProfileJson(user.getKey().getStringValue(), user.getFullName(), this.userAccessor.getUserProfilePicture((User)user).getUriReference(), user.getName()));
        }).collect(Collectors.toList());
    }

    public List<ActionLogJson> getActionLogs(int limit) {
        return Arrays.stream((ActionInstance[])this.activeObjects.find(ActionInstance.class, Query.select().order("DATE DESC").limit(limit))).map(actionInstance -> {
            ConfluenceUser user = this.userAccessor.getUserByName(actionInstance.getUser());
            Page page = this.pageManager.getPage(actionInstance.getPageId().longValue());
            return ActionLogJson.map(actionInstance, new PageJson(page.getId(), page.getDisplayTitle(), null), new UserProfileJson(user.getKey().getStringValue(), user.getFullName(), this.userAccessor.getUserProfilePicture((User)user).getUriReference(), user.getName()));
        }).collect(Collectors.toList());
    }

    public List<ActionLogJson> getActionLog(Integer actionId) {
        ActionInstance actionInstance = (ActionInstance)this.activeObjects.get(ActionInstance.class, (Object)actionId);
        ConfluenceUser user = this.userAccessor.getUserByName(actionInstance.getUser());
        Page page = this.pageManager.getPage(actionInstance.getPageId().longValue());
        return Arrays.asList(ActionLogJson.map(actionInstance, new PageJson(page.getId(), page.getDisplayTitle(), null), new UserProfileJson(user.getKey().getStringValue(), user.getFullName(), this.userAccessor.getUserProfilePicture((User)user).getUriReference(), user.getName())));
    }

    public void addActionLog(String user, String message, String status, Long objectId) {
        message = message.substring(0, Math.min(message.length(), 254));
        status = status.substring(0, Math.min(status.length(), 254));
        user = user.substring(0, Math.min(user.length(), 254));
        this.activeObjects.create(LogEntity.class, new DBParam[]{new DBParam("DATE", (Object)new Date()), new DBParam("MESSAGE", (Object)message), new DBParam("USER", (Object)user), new DBParam("STATUS", (Object)status), new DBParam("OBJECT_ID", (Object)objectId), new DBParam("TYPE", (Object)"action")});
    }

    public void addScanLog(String user, String message, String status) {
        message = message.substring(0, Math.min(message.length(), 254));
        status = status.substring(0, Math.min(status.length(), 254));
        user = user.substring(0, Math.min(user.length(), 254));
        this.activeObjects.create(LogEntity.class, new DBParam[]{new DBParam("DATE", (Object)new Date()), new DBParam("MESSAGE", (Object)message), new DBParam("USER", (Object)user), new DBParam("STATUS", (Object)status), new DBParam("TYPE", (Object)"scan")});
    }
}

