/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.helper;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import javax.inject.Named;

@Scanned
@Named(value="spaceHelper")
public class SpaceHelper {
    @ComponentImport
    private final CQLSearchService cqlSearchService;
    @ComponentImport
    private final SpaceService spaceService;

    @Inject
    public SpaceHelper(CQLSearchService cqlSearchService, SpaceService spaceService) {
        this.cqlSearchService = cqlSearchService;
        this.spaceService = spaceService;
    }

    public PageResponse<Space> getSpaces(int start, int limit) {
        return this.spaceService.find(new Expansion[0]).fetchMany((PageRequest)new SimplePageRequest(start, limit));
    }

    public int getSpaceCount() {
        SearchPageResponse results = this.cqlSearchService.search("type = space", SearchOptions.builder().build(), (PageRequest)new SimplePageRequest(0, 1), new Expansion[0]);
        return results.totalSize();
    }
}

