/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.entity.scope.ScopeEntity;
import co.uk.automationconsultants.compliance.entity.scope.ScopeSpaceEntity;
import co.uk.automationconsultants.compliance.json.scope.ScopeJson;
import co.uk.automationconsultants.compliance.json.scope.SpaceJson;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

@Scanned
@Path(value="/scope")
public class ScopeRest {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;

    @Inject
    public ScopeRest(ActiveObjects activeObjects, SpaceManager spaceManager, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager) {
        this.activeObjects = activeObjects;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getScope(@Context HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ScopeEntity[] scopeEntity = (ScopeEntity[])this.activeObjects.find(ScopeEntity.class, Query.select().order("ID DESC").limit(1));
        ArrayList<SpaceJson> spaces = new ArrayList<SpaceJson>();
        for (ScopeSpaceEntity spaceEntity : (ScopeSpaceEntity[])this.activeObjects.find(ScopeSpaceEntity.class, Query.select())) {
            Space space = this.spaceManager.getSpace(spaceEntity.getSpaceKey());
            if (space == null) continue;
            spaces.add(new SpaceJson(space.getName(), space.getKey()));
        }
        if (scopeEntity.length == 0) {
            this.activeObjects.create(ScopeEntity.class, new DBParam[]{new DBParam("SCOPE", (Object)"disabled")});
            return Response.ok((Object)new ScopeJson("disabled", new ArrayList<SpaceJson>())).build();
        }
        return Response.ok((Object)new ScopeJson(scopeEntity[0].getScope(), spaces)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateScope(@Context HttpServletRequest request, ScopeJson scopeJson) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ScopeEntity[] scopeEntity = (ScopeEntity[])this.activeObjects.find(ScopeEntity.class, Query.select().order("ID DESC").limit(1));
        if (scopeEntity.length == 0) {
            this.activeObjects.executeInTransaction(() -> (ScopeEntity)this.activeObjects.create(ScopeEntity.class, new DBParam[]{new DBParam("SCOPE", (Object)scopeJson.getScope())}));
        } else {
            this.activeObjects.executeInTransaction(() -> {
                scopeEntity[0].setScope(scopeJson.getScope());
                scopeEntity[0].save();
                return true;
            });
        }
        ScopeSpaceEntity[] existingSpaceEntities = (ScopeSpaceEntity[])this.activeObjects.find(ScopeSpaceEntity.class);
        List chosenSpaces = scopeJson.getSpaces().stream().map(SpaceJson::getValue).collect(Collectors.toList());
        this.activeObjects.executeInTransaction(() -> {
            for (ScopeSpaceEntity existingSpaceEntity : existingSpaceEntities) {
                if (chosenSpaces.contains(existingSpaceEntity.getSpaceKey())) continue;
                this.activeObjects.delete(new RawEntity[]{existingSpaceEntity});
            }
            for (String chosenSpace : chosenSpaces) {
                if (this.activeObjects.count(ScopeSpaceEntity.class, Query.select().where("SPACE_KEY = ?", new Object[]{chosenSpace})) != 0) continue;
                this.activeObjects.create(ScopeSpaceEntity.class, new DBParam[]{new DBParam("SPACE_KEY", (Object)chosenSpace)});
            }
            return true;
        });
        return Response.ok().build();
    }
}

