/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.cache;

import co.uk.automationconsultants.compliance.entity.extractions.ExtractionEntity;
import co.uk.automationconsultants.compliance.json.capture.ExtractionRegExJson;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
@Named(value="patternCache")
public class PatternCache {
    private static final Logger log = LoggerFactory.getLogger(PatternCache.class);
    @ComponentImport
    private final CacheManager cacheManager;
    private final Cache<Integer, Pattern> patternCache;
    @ComponentImport
    private final ActiveObjects activeObjects;

    @Inject
    public PatternCache(CacheManager cacheManager, ActiveObjects activeObjects) {
        this.cacheManager = cacheManager;
        this.patternCache = cacheManager.getCache(PatternCache.class.getName() + ".patternCache", (CacheLoader)new PatternCached(), new CacheSettingsBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maxEntries(1000).build());
        this.activeObjects = activeObjects;
    }

    public Pattern getPattern(Integer id) {
        return (Pattern)this.patternCache.get((Object)id);
    }

    public void invalidateCaches() {
        this.patternCache.removeAll();
    }

    public List<ExtractionRegExJson> getPatterns() {
        ArrayList<ExtractionRegExJson> output = new ArrayList<ExtractionRegExJson>();
        for (ExtractionEntity extractionEntity : (ExtractionEntity[])this.activeObjects.find(ExtractionEntity.class, "ENABLED = ?", new Object[]{true})) {
            try {
                output.add(new ExtractionRegExJson(extractionEntity.getID(), extractionEntity.getName(), this.getPattern(extractionEntity.getID()), extractionEntity.isEnabled()));
            }
            catch (Exception e) {
                log.error("Error Processing RegEx " + extractionEntity.getName() + " / " + e.getMessage());
            }
        }
        return output;
    }

    private class PatternCached
    implements CacheLoader<Integer, Pattern> {
        private PatternCached() {
        }

        public Pattern load(@Nonnull Integer id) {
            ExtractionEntity entity = (ExtractionEntity)PatternCache.this.activeObjects.get(ExtractionEntity.class, (Object)id);
            if (entity != null) {
                return Pattern.compile(entity.getRegEx());
            }
            return null;
        }
    }
}

