/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.service.LogService;
import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Scanned
@Path(value="/log")
@PublicApi
public class LogRest {
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final LogService logService;

    @Inject
    public LogRest(LogService logService, PermissionManager permissionManager, UserManager userManager, UserAccessor userAccessor) {
        this.logService = logService;
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getLogs(@Context HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok(this.logService.getLogs(1000)).build();
    }

    @GET
    @Path(value="/actionLog")
    @Produces(value={"application/json"})
    public Response getActionLogs(@Context HttpServletRequest request, @QueryParam(value="actionId") Integer aId) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (aId != null) {
            return Response.ok(this.logService.getActionLog(aId)).build();
        }
        return Response.ok(this.logService.getActionLogs(1000)).build();
    }
}

