/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.cache.GlobalSettingsCache;
import co.uk.automationconsultants.compliance.entity.SettingEntity;
import co.uk.automationconsultants.compliance.json.level.LevelRestrictionJson;
import co.uk.automationconsultants.compliance.json.settings.GlobalSettingsJson;
import co.uk.automationconsultants.compliance.json.settings.ScanSettings;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.java.ao.Query;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
@Path(value="/global")
public class GlobalRest {
    private static final Logger log = LoggerFactory.getLogger(GlobalRest.class);
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    private final GlobalSettingsCache globalSettingsCache;

    @Inject
    public GlobalRest(ActiveObjects activeObjects, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, GlobalSettingsCache globalSettingsCache) {
        this.activeObjects = activeObjects;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.globalSettingsCache = globalSettingsCache;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getGlobalSettings(@Context HttpServletRequest request) throws IOException {
        SettingEntity[] settings = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
        if (settings.length == 0) {
            return Response.ok((Object)new GlobalSettingsJson("Data Classification: ", "medium", true, false, false, true, true, true, false, false, false, null, false, true, false)).build();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        GlobalSettingsJson globalSettingsJson = new GlobalSettingsJson();
        globalSettingsJson.setPreface(settings[0].getMacroPreface() != null ? settings[0].getMacroPreface() : "Data Classification: ");
        globalSettingsJson.setForce(settings[0].getForce() != null ? settings[0].getForce() : false);
        globalSettingsJson.setInherit(settings[0].getInherit() != null ? settings[0].getInherit() : false);
        globalSettingsJson.setPrintOnly(settings[0].getPrintOnly() != null ? settings[0].getPrintOnly() : true);
        globalSettingsJson.setSize(settings[0].getMacroSize() != null ? settings[0].getMacroSize() : "medium");
        globalSettingsJson.setSpaceData(settings[0].getSpaceData() != null ? settings[0].getSpaceData() : true);
        globalSettingsJson.setSpaceLevel(settings[0].getSpaceLevel() != null ? settings[0].getSpaceLevel() : true);
        globalSettingsJson.setDataByline(settings[0].getDataByline() != null ? settings[0].getDataByline() : true);
        globalSettingsJson.setForceGloballyControlled(settings[0].getGloballyControlledForce() != null ? settings[0].getGloballyControlledForce() : false);
        globalSettingsJson.setRestrict(settings[0].getRestrict() != null ? settings[0].getRestrict() : false);
        globalSettingsJson.setRestrictGloballyControlled(settings[0].getRestrictGloballyControlled() != null ? settings[0].getRestrictGloballyControlled() : false);
        globalSettingsJson.setRestrictions(settings[0].getRestrictions() != null ? (List)objectMapper.readValue(settings[0].getRestrictions(), (TypeReference)new TypeReference<List<LevelRestrictionJson>>(){}) : null);
        globalSettingsJson.setClassificationGloballyControlled(settings[0].getClassiGloballyControlled() != null ? settings[0].getClassiGloballyControlled() : false);
        globalSettingsJson.setClassificationEnabled(settings[0].isClassificationEnabled() != null ? settings[0].isClassificationEnabled() : true);
        globalSettingsJson.setOnlyCheckEditPerms(settings[0].getOnlyCheckEditPerms() != null ? settings[0].getOnlyCheckEditPerms() : false);
        return Response.ok((Object)globalSettingsJson).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response setGlobalSettings(@Context HttpServletRequest request, GlobalSettingsJson newSettings) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SettingEntity[] settings = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
        if (settings.length == 0) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        SettingEntity settingEntity = (SettingEntity)this.activeObjects.executeInTransaction(() -> {
            if (newSettings.getForce() != null) {
                settings[0].setForce(newSettings.getForce());
            }
            if (newSettings.getPrintOnly() != null) {
                settings[0].setPrintOnly(newSettings.getPrintOnly());
            }
            if (newSettings.getPreface() != null) {
                settings[0].setMacroPreface(newSettings.getPreface());
            }
            if (newSettings.getSize() != null) {
                settings[0].setMacroSize(newSettings.getSize());
            }
            if (newSettings.getDataByline() != null) {
                settings[0].setDataByline(newSettings.getDataByline());
            }
            if (newSettings.getSpaceData() != null) {
                settings[0].setSpaceData(newSettings.getSpaceData());
            }
            if (newSettings.getSpaceLevel() != null) {
                settings[0].setSpaceLevel(newSettings.getSpaceLevel());
            }
            if (newSettings.getForceGloballyControlled() != null) {
                settings[0].setGloballyControlledForce(newSettings.getForceGloballyControlled());
            }
            if (newSettings.getRestrict() != null) {
                settings[0].setRestrict(newSettings.getRestrict());
            }
            if (newSettings.getRestrictGloballyControlled() != null) {
                settings[0].setRestrictGloballyControlled(newSettings.getRestrictGloballyControlled());
            }
            if (newSettings.getRestrictions() != null) {
                try {
                    settings[0].setRestrictions(objectMapper.writeValueAsString(newSettings.getRestrictions()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (newSettings.getClassificationGloballyControlled() != null) {
                settings[0].setClassiGloballyControlled(newSettings.getClassificationGloballyControlled());
            }
            if (newSettings.getClassificationEnabled() != null) {
                settings[0].setClassificationEnabled(newSettings.getClassificationEnabled());
            }
            if (newSettings.getOnlyCheckEditPerms() != null) {
                settings[0].setOnlyCheckEditPerms(newSettings.getOnlyCheckEditPerms());
            }
            if (newSettings.getInherit() != null) {
                settings[0].setInherit(newSettings.getInherit());
            }
            settings[0].save();
            this.globalSettingsCache.invalidateCaches();
            return settings[0];
        });
        return Response.ok((Object)new ScanSettings(settingEntity.getRealTimeScan(), settingEntity.getRealTimeScanPrevVersions(), settingEntity.getScheduledScan(), settingEntity.getActingUser())).build();
    }
}

