/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service.task;

import co.uk.automationconsultants.compliance.exception.task.TaskPingException;
import co.uk.automationconsultants.compliance.helper.ClusterHelper;
import co.uk.automationconsultants.compliance.service.task.TaskNotificationService;
import co.uk.automationconsultants.compliance.task.event.AllNodesNotificationEvent;
import co.uk.automationconsultants.compliance.utils.TaskClusterUtils;
import com.atlassian.confluence.api.service.settings.SettingsService;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.util.tomcat.TomcatConfigHelper;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
@Named
public class TaskNotificationServiceImpl
implements TaskNotificationService {
    private final ClusterHelper clusterHelper;
    @ComponentImport
    private final ClusterManager clusterManager;
    @ComponentImport
    private final TomcatConfigHelper tomcatConfigHelper;
    @ComponentImport
    private final SettingsService settingsService;
    private static final Logger log = LoggerFactory.getLogger(TaskNotificationServiceImpl.class);
    private static final String TASK_NOTIFY_PATH = "/rest/server-classification/1.0/task/notify";
    private static final String TASK_EXECUTOR_BUSY_PATH = "/rest/server-classification/1.0/task/executor-busy";

    @Inject
    public TaskNotificationServiceImpl(ClusterHelper clusterHelper, ClusterManager clusterManager, TomcatConfigHelper tomcatConfigHelper, SettingsService settingsService) {
        this.clusterHelper = clusterHelper;
        this.clusterManager = clusterManager;
        this.tomcatConfigHelper = tomcatConfigHelper;
        this.settingsService = settingsService;
    }

    @Override
    public void alertAllNodes() throws TaskPingException, IOException {
        if (this.clusterManager.isClustered() && this.clusterManager.getClusterInformation().getMemberCount() > 1) {
            log.debug("Clustered System. Alerting all nodes");
            this.clusterManager.publishEvent((ConfluenceEvent)new AllNodesNotificationEvent());
        } else {
            log.debug("Un-clustered System or system only has 1 node. Alerting only single node");
            this.alertNodeOfTask(this.clusterManager.getThisNodeInformation());
        }
    }

    @Override
    public void alertNodeOfTask(@Nullable ClusterNodeInformation clusterNodeInformation) throws IOException, TaskPingException {
        String urlToPing = this.getNodeUrl(clusterNodeInformation);
        log.debug("Gotten URL to Ping {}", (Object)urlToPing);
        this.sendTaskPing(urlToPing + TASK_NOTIFY_PATH);
        log.debug("Pinged Scanner on Node {}", (Object)(clusterNodeInformation == null ? "NO_CLUSTER" : clusterNodeInformation.getAnonymizedNodeIdentifier()));
    }

    @Override
    public boolean isExecutorBusy(@Nullable ClusterNodeInformation clusterNodeInformation) throws IOException, TaskPingException {
        String address = this.getNodeUrl(clusterNodeInformation) + TASK_EXECUTOR_BUSY_PATH;
        log.debug("Gotten URL to ping {}", (Object)address);
        return this.sendTaskRequest(address, Boolean.class);
    }

    @Override
    public boolean isExecutorBusy(@Nullable String clusterId) throws IOException, TaskPingException {
        ClusterNodeInformation clusterNodeInformation = this.clusterHelper.getNodeById(clusterId);
        return this.isExecutorBusy(clusterNodeInformation);
    }

    private String getNodeUrl(ClusterNodeInformation clusterNodeInformation) {
        return clusterNodeInformation != null ? TaskClusterUtils.getUrlToPing(clusterNodeInformation, this.tomcatConfigHelper, this.settingsService.getGlobalSettings()) : this.settingsService.getGlobalSettings().getBaseUrl();
    }

    private void sendTaskPing(String address) throws IOException, TaskPingException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(address);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new TaskPingException(address, statusCode);
            }
        }
    }

    private <T> T sendTaskRequest(String address, Class<T> tClass) throws IOException, TaskPingException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(address);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new TaskPingException(address, statusCode);
            }
            ObjectMapper mapper = new ObjectMapper();
            Object object = mapper.readValue(response.getEntity().getContent(), tClass);
            return (T)object;
        }
    }
}

