/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.entity.analysis.ExtractionResult;
import co.uk.automationconsultants.compliance.json.level.LevelJson;
import co.uk.automationconsultants.compliance.json.request.BulkChangeSensitiveDataRequestJson;
import co.uk.automationconsultants.compliance.json.settings.GlobalSettingsJson;
import co.uk.automationconsultants.compliance.service.AutomationService;
import co.uk.automationconsultants.compliance.service.ClassificationService;
import co.uk.automationconsultants.compliance.service.WhitelistService;
import co.uk.automationconsultants.compliance.utils.DataUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
@Path(value="/bulk-sensitive-data")
public class BulkChangeSensitiveDataRest {
    private static final Logger logger = LoggerFactory.getLogger(BulkChangeSensitiveDataRest.class);
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final EntityManagerProvider entityManagerProvider;
    private final AutomationService automationService;
    private final ClassificationService classificationService;
    private final WhitelistService whitelistService;

    @Inject
    public BulkChangeSensitiveDataRest(ActiveObjects activeObjects, SpaceManager spaceManager, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, AutomationService automationService, ClassificationService classificationService, WhitelistService whitelistService, EntityManagerProvider entityManagerProvider) {
        this.activeObjects = activeObjects;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.automationService = automationService;
        this.classificationService = classificationService;
        this.whitelistService = whitelistService;
        this.entityManagerProvider = entityManagerProvider;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doBulkChangeAction(@Context HttpServletRequest request, BulkChangeSensitiveDataRequestJson changeRequestJson) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        GlobalSettingsJson settings = this.classificationService.getSettings();
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List<LevelJson> levels = this.classificationService.getLevels();
        List batches = DataUtils.listToBatches(changeRequestJson.getItems(), 25);
        block12: for (List batch : batches) {
            this.entityManagerProvider.getEntityManager().clear();
            switch (changeRequestJson.getType()) {
                case "redact": {
                    this.automationService.redactSelectedItems(false, user, batch);
                    break;
                }
                case "whitelist": {
                    ExtractionResult result;
                    for (Object o : batch) {
                        int id = (Integer)o;
                        result = (ExtractionResult)this.activeObjects.get(ExtractionResult.class, (Object)id);
                        this.whitelistService.createWhitelistItem(result.getSpaceId(), result.getPageId(), result.getCapturedText());
                    }
                    continue block12;
                }
                case "classify": {
                    ExtractionResult result;
                    for (Object o : batch) {
                        try {
                            int id = (Integer)o;
                            result = (ExtractionResult)this.activeObjects.get(ExtractionResult.class, (Object)id);
                            this.classificationService.performClassification(result.getPageId(), (User)user, changeRequestJson.getLevel(), this.classificationService.getSpaceSettings(this.spaceManager.getSpace(result.getSpaceId().longValue()).getKey()), levels, settings, false);
                        }
                        catch (Exception e) {
                            logger.error("Error during Classify Bulk Change: " + e.getMessage());
                        }
                    }
                    continue block12;
                }
                default: {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
        }
        return Response.ok().build();
    }
}

