/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.json.analysis;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PageJson {
    @XmlElement(name="id")
    public Long id;
    @XmlElement(name="title")
    public String title;
    @XmlElement(name="version")
    public Integer version;

    public PageJson() {
    }

    public PageJson(Long id, String title, Integer version) {
        this.id = id;
        this.title = title;
        this.version = version;
    }

    public static PageJson map(PageManager pageManager, Long pageId, Integer pageVersion) {
        if (pageId == null) {
            return null;
        }
        Page page = pageManager.getPage(pageId.longValue());
        if (page == null) {
            return null;
        }
        return new PageJson(page.getId(), page.getDisplayTitle(), pageVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageJson pageJson = (PageJson)o;
        return this.id.equals(pageJson.id) && this.title.equals(pageJson.title) && this.version.equals(pageJson.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.version);
    }

    public String toString() {
        return "PageJson{id=" + this.id + ", title='" + this.title + "', version=" + this.version + "}";
    }
}

