/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service.task;

import co.uk.automationconsultants.compliance.entity.task.Task;
import co.uk.automationconsultants.compliance.entity.task.TaskLog;
import co.uk.automationconsultants.compliance.exception.task.InvalidParamsException;
import co.uk.automationconsultants.compliance.exception.task.InvalidTaskTypeException;
import co.uk.automationconsultants.compliance.exception.task.NoSuchTaskException;
import co.uk.automationconsultants.compliance.json.task.LogLevelEnum;
import co.uk.automationconsultants.compliance.json.task.TaskCreationJson;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.TaskLogJson;
import co.uk.automationconsultants.compliance.json.task.TaskStatusEnum;
import co.uk.automationconsultants.compliance.json.task.TaskTypeEnum;
import co.uk.automationconsultants.compliance.json.task.params.BulkChangeCQLParams;
import co.uk.automationconsultants.compliance.json.task.params.BulkSpaceParams;
import co.uk.automationconsultants.compliance.json.task.params.SensitiveDataScanParams;
import co.uk.automationconsultants.compliance.json.task.search.LogSearchCursor;
import co.uk.automationconsultants.compliance.json.task.search.TaskLogSearchFilterJson;
import co.uk.automationconsultants.compliance.json.task.search.TaskSearchCursor;
import co.uk.automationconsultants.compliance.json.task.search.TaskSearchFilterJson;
import co.uk.automationconsultants.compliance.search.SearchResponse;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.service.task.TaskFunction;
import co.uk.automationconsultants.compliance.task.search.TaskLogSearchHelper;
import co.uk.automationconsultants.compliance.task.search.TaskSearchHelper;
import co.uk.automationconsultants.compliance.utils.task.TaskDBServiceUtils;
import co.uk.automationconsultants.compliance.utils.task.TaskVerificationUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;

@Scanned
@Named(value="taskDBService")
public class TaskDBServiceImpl
implements TaskDBService {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final CQLSearchService cqlSearchService;
    @ComponentImport
    private final SpaceService spaceService;

    @Inject
    public TaskDBServiceImpl(ActiveObjects activeObjects, CQLSearchService cqlSearchService, SpaceService spaceService) {
        this.activeObjects = activeObjects;
        this.cqlSearchService = cqlSearchService;
        this.spaceService = spaceService;
    }

    @Override
    public TaskJson addTask(TaskCreationJson taskCreationJson, String clusterIdentifier, String creator) throws InvalidTaskTypeException, InvalidParamsException {
        TaskTypeEnum taskTypeEnum = this.getTaskTypeEnum(taskCreationJson.getTaskType()).orElseThrow(InvalidTaskTypeException::new);
        if (!this.isValidParams(taskTypeEnum, taskCreationJson.getParamsJson())) {
            throw new InvalidParamsException();
        }
        return TaskDBServiceUtils.createDefaultTask(this.activeObjects, taskTypeEnum, taskCreationJson.getParamsJson(), creator, clusterIdentifier);
    }

    @Override
    @Nullable
    public TaskJson getTask(int taskId) {
        Task task = (Task)this.activeObjects.get(Task.class, (Object)taskId);
        return TaskJson.toTaskJson(task);
    }

    private Task getTaskInterface(int taskId) {
        return (Task)this.activeObjects.get(Task.class, (Object)taskId);
    }

    @Override
    public void cancelTask(int taskId) {
        Task task = (Task)this.activeObjects.get(Task.class, (Object)taskId);
        String status = task.getTaskStatus();
        boolean canBeCancelled = Stream.of(TaskStatusEnum.PENDING, TaskStatusEnum.DELEGATED, TaskStatusEnum.READY_TO_EXECUTE, TaskStatusEnum.IN_PROGRESS).anyMatch(taskStatusEnum -> taskStatusEnum.name().equals(status));
        if (canBeCancelled) {
            task.setTaskStatus(TaskStatusEnum.CANCELLED.name());
            task.setTimeEnded(new Date());
            task.setLastStatusChange(new Date());
            task.save();
        }
    }

    @Override
    public TaskJson updateTask(@Nonnull TaskJson update) throws NoSuchTaskException, IllegalArgumentException {
        TaskVerificationUtils.verifyTaskUpdate(update);
        return TaskDBServiceUtils.applyTaskUpdate(this.activeObjects, update);
    }

    @Override
    public TaskJson updateTaskNoVerification(@Nonnull TaskJson update) throws NoSuchTaskException {
        return TaskDBServiceUtils.applyTaskUpdate(this.activeObjects, update);
    }

    @Override
    public void killTask(int taskId) {
        Task task = (Task)this.activeObjects.get(Task.class, (Object)taskId);
        String status = task.getTaskStatus();
        if (status.equals(TaskStatusEnum.PENDING.name()) || status.equals(TaskStatusEnum.IN_PROGRESS.name())) {
            task.setTaskStatus(TaskStatusEnum.TERMINATED.name());
            task.setLastStatusChange(new Date());
            task.setTimeEnded(new Date());
            task.save();
        }
    }

    @Override
    public TaskLogJson addTaskLog(int taskId, LogLevelEnum logLevelEnum, String message) {
        TaskLog taskLog = (TaskLog)this.activeObjects.create(TaskLog.class, new DBParam[]{new DBParam("TIME_CREATED", (Object)new Date()), new DBParam("MESSAGE", (Object)message), new DBParam("LOG_LEVEL", (Object)logLevelEnum.name()), new DBParam("TASK_ID", (Object)taskId)});
        return TaskLogJson.toTaskLogJson(taskLog);
    }

    @Override
    public TaskLogJson addTaskLog(int taskId, LogLevelEnum logLevelEnum, String message, Long pageId, Long spaceId, String spaceKey) {
        TaskLog taskLog = (TaskLog)this.activeObjects.create(TaskLog.class, new DBParam[]{new DBParam("TIME_CREATED", (Object)new Date()), new DBParam("MESSAGE", (Object)message), new DBParam("LOG_LEVEL", (Object)logLevelEnum.name()), new DBParam("PAGE_ID", (Object)pageId), new DBParam("SPACE_ID", (Object)spaceId), new DBParam("SPACE_KEY", (Object)spaceKey), new DBParam("TASK_ID", (Object)taskId)});
        return TaskLogJson.toTaskLogJson(taskLog);
    }

    @Override
    public SearchResponse<TaskLogJson> searchTaskLogs(int taskId, int limit) throws NoSuchTaskException {
        return this.searchTaskLogs(taskId, limit, null, new ArrayList<String>(), false, true);
    }

    @Override
    public SearchResponse<TaskLogJson> searchTaskLogs(int taskId, int limit, boolean expand) throws NoSuchTaskException {
        return this.searchTaskLogs(taskId, limit, null, new ArrayList<String>(), expand, true);
    }

    @Override
    public SearchResponse<TaskLogJson> searchTaskLogs(int taskId, int limit, boolean expand, boolean oldestFirst) throws NoSuchTaskException {
        return this.searchTaskLogs(taskId, limit, null, new ArrayList<String>(), expand, oldestFirst);
    }

    @Override
    public SearchResponse<TaskLogJson> searchTaskLogs(int taskId, int limit, String cursor, List<String> logLevels, boolean expand, boolean oldestFirst) throws NoSuchTaskException {
        TaskLogSearchFilterJson filter = new TaskLogSearchFilterJson(taskId, logLevels);
        Task task = (Task)this.activeObjects.get(Task.class, (Object)taskId);
        if (task == null) {
            throw new NoSuchTaskException(taskId);
        }
        TaskLogSearchHelper taskLogSearchHelper = new TaskLogSearchHelper();
        LogSearchCursor searchCursor = taskLogSearchHelper.parseCursor(cursor);
        Query query = taskLogSearchHelper.generateQuery(searchCursor, filter, limit, oldestFirst);
        TaskLog[] taskLogs = (TaskLog[])this.activeObjects.find(TaskLog.class, query);
        ArrayList<TaskLogJson> logs = new ArrayList<TaskLogJson>(Arrays.asList(expand ? TaskLogJson.toTaskLogJsons(taskLogs, this.cqlSearchService, this.spaceService) : TaskLogJson.toTaskLogJsons(taskLogs)));
        int totalCount = this.activeObjects.count(TaskLog.class, taskLogSearchHelper.generateCountQuery(filter));
        return taskLogSearchHelper.generateSearchResponse(totalCount, limit, searchCursor, logs);
    }

    @Override
    public SearchResponse<TaskJson> searchTasks(int limit, String cursor, TaskSearchFilterJson filter, boolean oldestFirst) {
        TaskSearchHelper taskSearchHelper = new TaskSearchHelper();
        TaskSearchCursor searchCursor = taskSearchHelper.parseCursor(cursor);
        Query query = taskSearchHelper.generateQuery(searchCursor, filter, limit, oldestFirst);
        List<TaskJson> tasks = TaskJson.toTaskJsonList((Task[])this.activeObjects.find(Task.class, query));
        int totalCount = this.activeObjects.count(Task.class, taskSearchHelper.generateCountQuery(filter));
        return taskSearchHelper.generateSearchResponse(totalCount, limit, searchCursor, tasks);
    }

    @Override
    public void executeForTasks(TaskSearchFilterJson filter, TaskFunction taskFunction) {
        String cursor = null;
        int limit = 50;
        boolean isMore = true;
        while (isMore) {
            SearchResponse<TaskJson> taskSearchResponse = this.searchTasks(50, cursor, filter, true);
            for (TaskJson task : taskSearchResponse.getResults()) {
                taskFunction.execute(task);
            }
            cursor = taskSearchResponse.getNext();
            isMore = cursor != null;
        }
    }

    private List<TaskJson> getAllTasks(TaskSearchFilterJson filter) {
        ArrayList<TaskJson> allResults = new ArrayList<TaskJson>();
        String nextCursor = null;
        int limit = 50;
        do {
            SearchResponse<TaskJson> searchResponse = this.searchTasks(50, nextCursor, filter, true);
            nextCursor = searchResponse.getNext();
            List<TaskJson> tasks = searchResponse.getResults();
            allResults.addAll(tasks);
        } while (nextCursor != null);
        return allResults;
    }

    @Override
    public List<TaskJson> getAllTasksByStatuses(TaskStatusEnum ... statuses) {
        if (statuses.length == 0) {
            return new ArrayList<TaskJson>();
        }
        return this.getAllTasks(TaskSearchFilterJson.builder().status(statuses).build());
    }

    @Override
    public void terminateRunningTasks(String electedNodeId) {
        Query query = Query.select().where("TASK_STATUS = ? AND ELECTED_NODE = ?", new Object[]{TaskStatusEnum.IN_PROGRESS.name(), electedNodeId});
        this.activeObjects.stream(Task.class, query, task -> this.killTask(task.getID()));
    }

    @Override
    public void incrementSuccessValue(int taskId, int delta) {
        Task task = this.getTaskInterface(taskId);
        int success = task.getSuccess();
        task.setSuccess(success + delta);
        task.setLastStatusChange(new Date());
        task.save();
    }

    @Override
    public void incrementFailedValue(int taskId, int delta) {
        Task task = this.getTaskInterface(taskId);
        int failed = task.getFailed();
        task.setFailed(failed + delta);
        task.setLastStatusChange(new Date());
        task.save();
    }

    @Override
    public void incrementWarningValue(int taskId, int delta) {
        Task task = this.getTaskInterface(taskId);
        int warning = task.getWarning();
        task.setWarning(warning + delta);
        task.setLastStatusChange(new Date());
        task.save();
    }

    @Override
    public void updateTotalCount(int taskId, int totalCount) {
        Task task = this.getTaskInterface(taskId);
        task.setTotalCount(totalCount);
        task.setLastStatusChange(new Date());
        task.save();
    }

    @Override
    public void updateSkipped(int taskId) {
        Task task = this.getTaskInterface(taskId);
        task.setSkipped(task.getTotalCount() - (task.getSuccess() + task.getFailed() + task.getWarning()));
        task.setLastStatusChange(new Date());
        task.save();
    }

    @Override
    public List<TaskJson> runQueryOnTaskTable(Query query) {
        Task[] tasks = (Task[])this.activeObjects.find(Task.class, query);
        return TaskJson.toTaskJsonList(tasks);
    }

    @Override
    public TaskJson updateLastStatusChange(int taskId, Date lastStatusChange) {
        Task task = this.getTaskInterface(taskId);
        task.setLastStatusChange(lastStatusChange);
        task.save();
        return TaskJson.toTaskJson(task);
    }

    private Optional<TaskTypeEnum> getTaskTypeEnum(String taskType) {
        try {
            return Optional.of(TaskTypeEnum.toTaskTypeEnum(taskType));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private boolean isValidParams(TaskTypeEnum taskTypeEnum, String params) {
        switch (taskTypeEnum) {
            case BULK_CHANGE_CQL: {
                return this.isValidBulkChangeCQLParams(params);
            }
            case BULK_CHANGE_SPACE: {
                return this.isValidBulkChangeSpaceParams(params);
            }
            case SENSITIVE_DATA_SCAN: {
                return this.isValidSensitiveDataScanParams(params);
            }
        }
        return true;
    }

    private boolean isValidBulkChangeSpaceParams(String params) {
        try {
            BulkSpaceParams bulkSpaceParams = (BulkSpaceParams)new Gson().fromJson(params, BulkSpaceParams.class);
            if (bulkSpaceParams == null) {
                return false;
            }
            if (bulkSpaceParams.getType() == null || !bulkSpaceParams.getType().equals("force") && !bulkSpaceParams.getType().equals("enabled")) {
                return false;
            }
            return bulkSpaceParams.getEnabled() != null;
        }
        catch (JsonSyntaxException e) {
            return false;
        }
    }

    private boolean isValidBulkChangeCQLParams(String params) {
        try {
            BulkChangeCQLParams bulkChangeCQLParams = (BulkChangeCQLParams)new Gson().fromJson(params, BulkChangeCQLParams.class);
            return bulkChangeCQLParams != null && bulkChangeCQLParams.getQuery() != null && !bulkChangeCQLParams.getQuery().isEmpty() && bulkChangeCQLParams.getLevel() != null;
        }
        catch (JsonSyntaxException e) {
            return false;
        }
    }

    private boolean isValidSensitiveDataScanParams(String params) {
        try {
            SensitiveDataScanParams sensitiveDataScanParams = (SensitiveDataScanParams)new Gson().fromJson(params, SensitiveDataScanParams.class);
            return sensitiveDataScanParams != null;
        }
        catch (JsonSyntaxException e) {
            return false;
        }
    }
}

