/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service;

import co.uk.automationconsultants.compliance.entity.analysis.ExtractionResult;
import co.uk.automationconsultants.compliance.entity.extractions.WhitelistEntity;
import co.uk.automationconsultants.compliance.json.capture.WhitelistFullJson;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

@Scanned
@Named(value="whitelistService")
public class WhitelistService {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final PageManager pageManager;

    @Inject
    public WhitelistService(ActiveObjects activeObjects, SpaceManager spaceManager, PageManager pageManager) {
        this.activeObjects = activeObjects;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
    }

    public List<WhitelistEntity> getApplicableRules(Long spaceId, Long pageId) {
        return Arrays.asList((WhitelistEntity[])this.activeObjects.find(WhitelistEntity.class, Query.select().where("(SPACE_ID = ? AND PAGE_ID = ?) OR (SPACE_ID = ? AND PAGE_ID = ?) OR PAGE_ID = ?", new Object[]{null, null, spaceId, null, pageId})));
    }

    public List<WhitelistFullJson> getWhitelist() {
        return Arrays.stream((WhitelistEntity[])this.activeObjects.find(WhitelistEntity.class, Query.select())).map(whitelistEntity -> WhitelistFullJson.map(whitelistEntity, this.spaceManager, this.pageManager)).collect(Collectors.toList());
    }

    public boolean deleteWhitelistItem(Integer id) {
        return (Boolean)this.activeObjects.executeInTransaction(() -> {
            WhitelistEntity whitelistEntity = (WhitelistEntity)this.activeObjects.get(WhitelistEntity.class, (Object)id);
            if (whitelistEntity != null) {
                String text = whitelistEntity.getText();
                if (whitelistEntity.getPageId() != null && whitelistEntity.getSpaceId() != null) {
                    ExtractionResult[] result;
                    for (ExtractionResult res : result = (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, "CAPTURED_TEXT = ? AND PAGE_ID = ? AND SPACE_ID = ?", new Object[]{text, whitelistEntity.getPageId(), whitelistEntity.getSpaceId()})) {
                        res.setStatus(null);
                        res.save();
                    }
                } else if (whitelistEntity.getPageId() == null && whitelistEntity.getSpaceId() != null) {
                    ExtractionResult[] result;
                    for (ExtractionResult res : result = (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, "CAPTURED_TEXT = ? AND SPACE_ID = ?", new Object[]{text, whitelistEntity.getSpaceId()})) {
                        res.setStatus(null);
                        res.save();
                    }
                } else {
                    ExtractionResult[] result;
                    for (ExtractionResult res : result = (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, "CAPTURED_TEXT = ?", new Object[]{text})) {
                        res.setStatus(null);
                        res.save();
                    }
                }
                this.activeObjects.delete(new RawEntity[]{whitelistEntity});
                return true;
            }
            return false;
        });
    }

    public WhitelistEntity createWhitelistItem(Long spaceId, Long pageId, String text) {
        if (spaceId == null && pageId == null) {
            this.activeObjects.executeInTransaction(() -> {
                ExtractionResult[] result;
                for (ExtractionResult res : result = (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, "CAPTURED_TEXT = ?", new Object[]{text})) {
                    res.setStatus("WHITELISTED");
                    res.save();
                }
                return null;
            });
        } else if (spaceId != null && pageId == null) {
            this.activeObjects.executeInTransaction(() -> {
                ExtractionResult[] result;
                for (ExtractionResult res : result = (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, "CAPTURED_TEXT = ? AND SPACE_ID = ?", new Object[]{text, spaceId})) {
                    res.setStatus("WHITELISTED");
                    res.save();
                }
                return null;
            });
        } else {
            this.activeObjects.executeInTransaction(() -> {
                ExtractionResult[] result;
                for (ExtractionResult res : result = (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, "CAPTURED_TEXT = ? AND SPACE_ID = ? AND PAGE_ID = ?", new Object[]{text, spaceId, pageId})) {
                    res.setStatus("WHITELISTED");
                    res.save();
                }
                return null;
            });
        }
        return (WhitelistEntity)this.activeObjects.create(WhitelistEntity.class, new DBParam[]{new DBParam("SPACE_ID", (Object)spaceId), new DBParam("PAGE_ID", (Object)pageId), new DBParam("TEXT", (Object)text)});
    }
}

