/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.scheduler;

import co.uk.automationconsultants.compliance.service.NotificationService;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;

@Scanned
@Named(value="scheduledNotificationJobRunner")
public class ScheduledNotificationJobRunner
implements JobRunner {
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private final NotificationService notificationService;

    @Inject
    public ScheduledNotificationJobRunner(TransactionTemplate transactionTemplate, NotificationService notificationService) {
        this.transactionTemplate = transactionTemplate;
        this.notificationService = notificationService;
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        try {
            return (JobRunnerResponse)this.transactionTemplate.execute(() -> {
                if (this.notificationService.sendNotifications()) {
                    return JobRunnerResponse.success((String)"Completed");
                }
                return JobRunnerResponse.failed((String)"Failed");
            });
        }
        catch (Exception e) {
            return JobRunnerResponse.failed((Throwable)e);
        }
    }
}

