/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.json.level.LevelRestrictionJson;
import co.uk.automationconsultants.compliance.json.settings.BulkSpaceSettingsActionJson;
import co.uk.automationconsultants.compliance.json.settings.BulkSpaceSettingsJson;
import co.uk.automationconsultants.compliance.json.settings.BulkSpaceSettingsResponseJson;
import co.uk.automationconsultants.compliance.json.settings.SpaceSettingsJson;
import co.uk.automationconsultants.compliance.service.BulkChangeSpaceService;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.JsonSpaceProperty;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.SpacePropertyService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.atlassian.plugins.rest.common.json.JsonMarshallingException;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
@Path(value="/bulkChangeSpace")
public class BulkChangeSpaceRest {
    private static final Logger log = LoggerFactory.getLogger(BulkChangeSpaceRest.class);
    private final BulkChangeSpaceService bulkChangeSpaceService;
    @ComponentImport
    private final SpacePropertyService spacePropertyService;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final JaxbJsonMarshaller jaxbJsonMarshaller;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final SpacePermissionManager spacePermissionManager;

    @Inject
    public BulkChangeSpaceRest(BulkChangeSpaceService bulkChangeSpaceService, SpacePropertyService spacePropertyService, SpaceManager spaceManager, JaxbJsonMarshaller jaxbJsonMarshaller, PermissionManager permissionManager, UserManager userManager, UserAccessor userAccessor, SpacePermissionManager spacePermissionManager) {
        this.bulkChangeSpaceService = bulkChangeSpaceService;
        this.spacePropertyService = spacePropertyService;
        this.spaceManager = spaceManager;
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
        this.permissionManager = permissionManager;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.spacePermissionManager = spacePermissionManager;
    }

    @GET
    @Path(value="/recover-permissions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response recoverPermissions(@Context HttpServletRequest context) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(context)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List spaces = this.spaceManager.getAllSpaces();
        for (Space space : spaces) {
            if (this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, (Object)space)) continue;
            this.spacePermissionManager.savePermission(new SpacePermission("SETSPACEPERMISSIONS", space, null, user));
            this.spacePermissionManager.savePermission(new SpacePermission("VIEWSPACE", space, null, user));
            this.spacePermissionManager.flushCaches();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/getSpaces")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSpaces(@Context HttpServletRequest request, @QueryParam(value="showSettings") @DefaultValue(value="true") boolean showSettings) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((int)403).build();
        }
        List spaces = this.spaceManager.getAllSpaces();
        ArrayList<BulkSpaceSettingsJson> spaceSettingJsons = new ArrayList<BulkSpaceSettingsJson>();
        int viewPermissionCount = 0;
        int adminPermissionCount = 0;
        for (Space s : spaces) {
            boolean hasViewPermission = this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)s);
            boolean hasAdminPermission = this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, (Object)s);
            if (hasViewPermission) {
                ++viewPermissionCount;
            }
            if (hasViewPermission && hasAdminPermission) {
                ++adminPermissionCount;
            }
            if (!showSettings) continue;
            SpaceSettingsJson spaceSettings = this.getSpaceSettings(s.getKey());
            if (spaceSettings != null) {
                BulkSpaceSettingsJson bulkSpaceSettingsJson = new BulkSpaceSettingsJson(s.getId(), s.getKey(), s.getName(), this.spaceManager.getLogoForSpace(s.getKey()).getDownloadPath(), spaceSettings);
                spaceSettingJsons.add(bulkSpaceSettingsJson);
                continue;
            }
            SpaceSettingsJson defaultJson = new SpaceSettingsJson(true, false, false, new ArrayList<LevelRestrictionJson>(), new ArrayList<String>());
            String spaceSettingsJsonString = this.getSpaceSettingsJsonString(defaultJson);
            JsonSpaceProperty property = this.buildSpaceProperty(s.getKey(), spaceSettingsJsonString);
            SpaceSettingsJson createdProperty = this.createSpaceProperty(property);
            if (createdProperty == null) continue;
            BulkSpaceSettingsJson bulkSpaceSettingsJson = new BulkSpaceSettingsJson(s.getId(), s.getKey(), s.getName(), this.spaceManager.getLogoForSpace(s.getKey()).getDownloadPath(), createdProperty);
            spaceSettingJsons.add(bulkSpaceSettingsJson);
        }
        return Response.ok((Object)new BulkSpaceSettingsResponseJson(spaces.size(), adminPermissionCount, viewPermissionCount, spaceSettingJsons)).build();
    }

    private SpaceSettingsJson createSpaceProperty(JsonSpaceProperty propertyToCreate) {
        ValidationResult result = this.spacePropertyService.validator().validateCreate(propertyToCreate);
        if (result.isValid() && result.isAuthorized()) {
            JsonSpaceProperty createdProperty = this.spacePropertyService.create(propertyToCreate);
            ObjectMapper mapper = new ObjectMapper();
            try {
                return (SpaceSettingsJson)mapper.readValue(createdProperty.getValue().getValue(), SpaceSettingsJson.class);
            }
            catch (IOException i) {
                i.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private JsonSpaceProperty buildSpaceProperty(String spaceKey, String spaceSettingsJson) {
        return ((JsonSpaceProperty.SpacePropertyBuilder)((JsonSpaceProperty.SpacePropertyBuilder)((JsonSpaceProperty.SpacePropertyBuilder)JsonSpaceProperty.builder().space(com.atlassian.confluence.api.model.content.Space.builder().key(spaceKey).build()).key("dataclassification")).value(new JsonString(spaceSettingsJson))).version(Version.builder().number(1).build())).build();
    }

    @POST
    @Path(value="/changeSpaces")
    public Response changeSpaces(@Context HttpServletRequest request, BulkSpaceSettingsActionJson bulkSpaceSettingsActionJson) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((int)403).build();
        }
        if (bulkSpaceSettingsActionJson.getSpaceId().length() == 0) {
            List spaces = this.spaceManager.getAllSpaces();
            for (Space s : spaces) {
                this.modifySpaceSettingsNoException(s.getKey(), bulkSpaceSettingsActionJson.isAction(), bulkSpaceSettingsActionJson.getType());
            }
        } else {
            this.modifySpaceSettingsNoException(bulkSpaceSettingsActionJson.getSpaceId(), bulkSpaceSettingsActionJson.isAction(), bulkSpaceSettingsActionJson.getType());
        }
        return Response.ok((Object)"{}").build();
    }

    private void modifySpaceSettingsNoException(String spaceKey, boolean action, String type) {
        try {
            this.bulkChangeSpaceService.modifySpaceSettings(spaceKey, action, type);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
        }
    }

    private String getSpaceSettingsJsonString(SpaceSettingsJson json) {
        try {
            return this.jaxbJsonMarshaller.marshal((Object)json);
        }
        catch (JsonMarshallingException e) {
            log.error("Error Marshalling Analysis Tracker JSON - " + e.getMessage());
            return null;
        }
    }

    private SpaceSettingsJson getSpaceSettings(String spaceKey) {
        Option dataclassification = this.spacePropertyService.find(new Expansion[0]).withSpaceKey(spaceKey).withPropertyKey("dataclassification").fetchOne();
        JsonSpaceProperty settings = (JsonSpaceProperty)dataclassification.getOrNull();
        if (settings != null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                return (SpaceSettingsJson)mapper.readValue(settings.getValue().getValue(), SpaceSettingsJson.class);
            }
            catch (IOException e) {
                log.error(e.getLocalizedMessage());
                return null;
            }
        }
        return null;
    }
}

