/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.task.tasks;

import co.uk.automationconsultants.compliance.json.level.LevelJson;
import co.uk.automationconsultants.compliance.json.settings.GlobalSettingsJson;
import co.uk.automationconsultants.compliance.json.settings.SpaceSettingsJson;
import co.uk.automationconsultants.compliance.json.task.LogLevelEnum;
import co.uk.automationconsultants.compliance.json.task.params.BulkChangeCQLParams;
import co.uk.automationconsultants.compliance.service.ClassificationService;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.task.TaskRunnable;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.google.gson.Gson;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkChangeCQLTask
extends TaskRunnable {
    private final ClassificationService classificationService;
    private final CQLSearchService cqlSearchService;
    private final ConfluenceUser user;
    private long delayTime = 0L;
    private long overallTime = 0L;
    private long timeSpentGettingSpaceSettings = 0L;
    private long timeSpentGettingCQLPages = 0L;
    private long timeSpentClassifyingPages = 0L;
    private long timeSpentUpdatingTask = 0L;
    private static final Logger logger = LoggerFactory.getLogger(BulkChangeCQLTask.class);

    public BulkChangeCQLTask(TaskDBService taskDBService, int taskId, String paramsJson, ConfluenceUser user, TransactionTemplate transactionTemplate, ClassificationService classificationService, CQLSearchService cqlSearchService) {
        super(taskDBService, taskId, paramsJson, user, transactionTemplate);
        this.classificationService = classificationService;
        this.cqlSearchService = cqlSearchService;
        this.user = user;
    }

    @Override
    public void execute() throws InterruptedException {
        long timeStart = System.currentTimeMillis();
        BulkChangeCQLParams params = (BulkChangeCQLParams)new Gson().fromJson(this.getParamsJson(), BulkChangeCQLParams.class);
        String cql = "type = page AND " + params.getQuery() + " ORDER BY id";
        this.updateTotalCount(this.getTotalCount(cql));
        GlobalSettingsJson settings = (GlobalSettingsJson)this.transactionTemplate.execute(this.classificationService::getSettings);
        List levels = (List)this.transactionTemplate.execute(this.classificationService::getLevels);
        int start = 0;
        int limit = 50;
        boolean isMore = true;
        if (params.getLevel() < 0 || params.getLevel() >= levels.size()) {
            this.addErrorLog("Level ID in params is invalid");
            return;
        }
        while (isMore && !this.isCancelled()) {
            long cqlStart = System.currentTimeMillis();
            PageResponse response = this.cqlSearchService.searchContent(cql, (PageRequest)new SimplePageRequest(start, limit), new Expansion[]{Expansion.combine((Object[])new Object[]{"space"})});
            this.timeSpentGettingCQLPages += System.currentTimeMillis() - cqlStart;
            int successCount = 0;
            List results = response.getResults();
            for (Content result : results) {
                if (this.isCancelled()) break;
                long id = result.getId().asLong();
                Space space = result.getSpace();
                boolean success = this.processPageWithRetry(params.getLevel(), settings, levels, id, space);
                if (!success) continue;
                ++successCount;
            }
            long progressStart = System.currentTimeMillis();
            this.updateProgress(results.size(), successCount, this.isCancelled());
            this.timeSpentUpdatingTask += System.currentTimeMillis() - progressStart;
            isMore = response.hasMore();
            start += limit;
        }
        this.overallTime = System.currentTimeMillis() - timeStart;
        this.printTimings();
    }

    private void updateProgress(int batchSize, int successCount, boolean cancelled) {
        this.transactionTemplate.execute(() -> {
            this.taskDBService.incrementSuccessValue(this.taskId, successCount);
            if (!cancelled) {
                this.taskDBService.incrementFailedValue(this.taskId, batchSize - successCount);
            } else {
                this.taskDBService.updateSkipped(this.taskId);
            }
            return null;
        });
    }

    private boolean processPage(int levelId, GlobalSettingsJson settings, List<LevelJson> levels, long pageId, Space space) {
        try {
            long spaceSettingsStart = System.currentTimeMillis();
            SpaceSettingsJson spaceSettings = this.classificationService.getSpaceSettings(space.getKey());
            this.timeSpentGettingSpaceSettings += System.currentTimeMillis() - spaceSettingsStart;
            long classifyPageStart = System.currentTimeMillis();
            boolean success = this.classificationService.performClassification(pageId, (User)this.user, levelId, spaceSettings, levels, settings, false);
            this.timeSpentClassifyingPages += System.currentTimeMillis() - classifyPageStart;
            if (!success) {
                this.addTaskLog(LogLevelEnum.ERROR, "Page could not be classified", pageId, space.getId(), space.getKey());
            }
            return success;
        }
        catch (Exception e) {
            this.addTaskLog(LogLevelEnum.ERROR, e.getMessage(), pageId, space.getId(), space.getKey());
            return false;
        }
    }

    private boolean processPageWithRetry(int levelId, GlobalSettingsJson settings, List<LevelJson> levels, long pageId, Space space) throws InterruptedException {
        boolean success = this.processPage(levelId, settings, levels, pageId, space);
        if (success) {
            return true;
        }
        long delay = 200L + this.delayTime;
        String message = String.format("First attempt failed. attempting to re-classify. delay: %dms", delay);
        this.addTaskLog(LogLevelEnum.INFO, message, pageId, space.getId(), space.getKey());
        Thread.sleep(delay);
        this.delayTime += 10L;
        return this.processPage(levelId, settings, levels, pageId, space);
    }

    private int getTotalCount(String cql) {
        return this.cqlSearchService.countContent(cql);
    }

    private void printTimings() {
        logger.debug("Overall time {}ms", (Object)this.overallTime);
        logger.debug("Time Spent in cql responses {}ms", (Object)this.timeSpentGettingCQLPages);
        logger.debug("Time Spent getting space settings {}ms", (Object)this.timeSpentGettingSpaceSettings);
        logger.debug("Time spent classifying pages {}ms", (Object)this.timeSpentClassifyingPages);
        logger.debug("Time Spent updating progress {}ms", (Object)this.timeSpentUpdatingTask);
    }
}

