/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.scheduler;

import co.uk.automationconsultants.compliance.exception.task.InvalidParamsException;
import co.uk.automationconsultants.compliance.exception.task.InvalidTaskTypeException;
import co.uk.automationconsultants.compliance.json.settings.ScanSettings;
import co.uk.automationconsultants.compliance.json.task.TaskCreationJson;
import co.uk.automationconsultants.compliance.json.task.TaskTypeEnum;
import co.uk.automationconsultants.compliance.json.task.params.SensitiveDataScanParams;
import co.uk.automationconsultants.compliance.service.settings.SettingsService;
import co.uk.automationconsultants.compliance.task.TaskManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.google.gson.Gson;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;

@Scanned
@Named(value="scheduledScanJobRunner")
public class ScheduledScanJobRunner
implements JobRunner {
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final SettingsService settingsService;
    private final TaskManager taskManager;

    @Inject
    public ScheduledScanJobRunner(TransactionTemplate transactionTemplate, UserAccessor userAccessor, SettingsService settingsService, TaskManager taskManager) {
        this.transactionTemplate = transactionTemplate;
        this.userAccessor = userAccessor;
        this.settingsService = settingsService;
        this.taskManager = taskManager;
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
        return (JobRunnerResponse)this.transactionTemplate.execute(() -> {
            ScanSettings scanSettings = this.settingsService.getScanSettings();
            if (scanSettings == null) {
                return JobRunnerResponse.failed((String)"Scan Settings could not be found");
            }
            Optional<String> optionalUserId = this.getActingUserId(scanSettings);
            if (!optionalUserId.isPresent()) {
                return JobRunnerResponse.failed((String)"The acting user is null");
            }
            return this.addSensitiveDataScanTask(optionalUserId.get());
        });
    }

    private JobRunnerResponse addSensitiveDataScanTask(String userId) {
        try {
            SensitiveDataScanParams params = new SensitiveDataScanParams(false);
            TaskCreationJson taskCreationJson = new TaskCreationJson(TaskTypeEnum.SENSITIVE_DATA_SCAN.name(), new Gson().toJson((Object)params));
            this.taskManager.addTask(taskCreationJson, userId);
            return JobRunnerResponse.success((String)"Task added to task manager successfully");
        }
        catch (InvalidParamsException | InvalidTaskTypeException e) {
            return JobRunnerResponse.failed((Throwable)e);
        }
    }

    private Optional<String> getActingUserId(ScanSettings scanSettings) {
        String actingUser = scanSettings.getActingUser();
        ConfluenceUser user = this.userAccessor.getUserByName(actingUser);
        return Optional.ofNullable(user).map(u -> u.getKey().getStringValue());
    }
}

