/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Scanned
@Path(value="/spaceAdmin")
public class SpaceAdminRest {
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final SpaceManager spaceManager;

    @Inject
    public SpaceAdminRest(UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, SpaceManager spaceManager) {
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response checkIfSpaceAdmin(@Context HttpServletRequest request, @QueryParam(value="spaceKey") String spaceKey) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        boolean isSpaceAdmin = this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, (Object)this.spaceManager.getSpace(spaceKey));
        String json = "{\"isSpaceAdmin\": " + isSpaceAdmin + "}";
        return Response.ok((Object)json, (String)"application/json").build();
    }
}

