/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.utils;

import com.atlassian.confluence.api.model.settings.GlobalSettings;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.util.tomcat.TomcatConfigHelper;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TaskClusterUtils {
    private TaskClusterUtils() {
    }

    private static String getPostfix(String baseUrl) {
        Pattern p = Pattern.compile("https?://([^/]+)(/.+)?");
        Matcher m = p.matcher(baseUrl);
        if (m.find()) {
            return Optional.ofNullable(m.group(2)).orElse("");
        }
        return "";
    }

    private static String getScheme(String baseUrl) {
        Pattern p = Pattern.compile("(https?://)?.+");
        Matcher m = p.matcher(baseUrl);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public static String getUrlToPing(ClusterNodeInformation clusterNodeInformation, TomcatConfigHelper tomcatConfigHelper, GlobalSettings globalSettings) {
        String hostName = clusterNodeInformation.getLocalSocketAddress().getHostString();
        String port = tomcatConfigHelper.getConnectorPort().orElse("");
        String postfix = TaskClusterUtils.getPostfix(globalSettings.getBaseUrl());
        String scheme = TaskClusterUtils.getScheme(globalSettings.getBaseUrl());
        return String.format("%s%s:%s%s", scheme, hostName, port, postfix);
    }

    public static String getClusterId(ClusterManager clusterManager) {
        return Optional.ofNullable(clusterManager.getThisNodeInformation()).map(ClusterNodeInformation::getAnonymizedNodeIdentifier).orElse("NO_CLUSTER");
    }
}

