/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.task;

import co.uk.automationconsultants.compliance.exception.task.TaskExecutionException;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.TaskStatusEnum;
import co.uk.automationconsultants.compliance.json.task.search.TaskSearchFilterJson;
import co.uk.automationconsultants.compliance.search.SearchResponse;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.service.task.TaskExecutionService;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskScanner
implements Runnable {
    private boolean readyToScan;
    private static final Logger log = LoggerFactory.getLogger(TaskScanner.class);
    private final TaskDBService taskDBService;
    private final ClusterNodeInformation clusterNodeInformation;
    private final TaskExecutionService taskExecutionService;
    private final TransactionTemplate transactionTemplate;
    private boolean runningThread = true;
    private final Thread thread;

    public TaskScanner(TaskDBService taskDBService, ClusterNodeInformation clusterNodeInformation, TaskExecutionService taskExecutionService, TransactionTemplate transactionTemplate) {
        this.taskDBService = taskDBService;
        this.clusterNodeInformation = clusterNodeInformation;
        this.taskExecutionService = taskExecutionService;
        this.transactionTemplate = transactionTemplate;
        this.thread = new Thread(this);
    }

    public synchronized void alertScanner() {
        log.debug("Scanner was alerted");
        this.readyToScan = true;
        this.runningThread = true;
        this.notifyAll();
    }

    public void startThread() {
        this.thread.start();
        if (!this.thread.isAlive()) {
            log.error("Task Scanning Thread failed to start");
        }
    }

    private synchronized void stopScanning() {
        this.readyToScan = false;
    }

    public synchronized void killThread() {
        this.runningThread = false;
    }

    @Override
    public synchronized void run() {
        while (this.runningThread) {
            while (!this.readyToScan) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error("Task Scanning Thread was interrupted");
                }
            }
            if (this.noTaskIsRunning()) {
                boolean continueProcessing = this.processTasks();
                if (!continueProcessing) {
                    this.stopScanning();
                }
            } else {
                this.stopScanning();
            }
            try {
                this.wait(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("Task Scanning Thread was interrupted");
            }
        }
    }

    private boolean processTasks() {
        int firstTaskIdInList = -1;
        String cursor = null;
        boolean hasMore = true;
        while (hasMore) {
            SearchResponse<TaskJson> searchResponse = this.getUnfinishedTasks(cursor);
            log.debug("No of unfinished tasks: {}", (Object)searchResponse.getTotalCount());
            List<TaskJson> tasks = searchResponse.getResults();
            if (tasks.isEmpty()) {
                return false;
            }
            if (firstTaskIdInList == -1) {
                firstTaskIdInList = tasks.get(0).getId();
            }
            for (TaskJson task : tasks) {
                log.debug("Now scanning task {}", (Object)task.getId());
                boolean taskBelongsToCurrNode = this.belongsToCurrNode(task);
                log.debug("task belongs to curr node {}", (Object)taskBelongsToCurrNode);
                if (task.isExclusiveExecution()) {
                    this.handleExclusiveTask(task, task.getId() == firstTaskIdInList, taskBelongsToCurrNode);
                    return false;
                }
                if (!taskBelongsToCurrNode) continue;
                this.handleNonExclusiveTask(task);
                return false;
            }
            cursor = searchResponse.getNext();
            hasMore = cursor != null;
        }
        return true;
    }

    private void handleExclusiveTask(TaskJson task, boolean firstTaskInList, boolean taskBelongsToCurrNode) {
        log.debug("Handling exclusive task {}", (Object)task.getId());
        if (firstTaskInList && taskBelongsToCurrNode && this.taskIsNotRunning(task.getId())) {
            this.runTask(task);
        }
    }

    private void handleNonExclusiveTask(TaskJson task) {
        if (this.taskIsNotRunning(task.getId()) && !this.taskExecutionService.isBusy()) {
            this.runTask(task);
        }
    }

    private void runTask(TaskJson task) {
        try {
            log.debug("Running exclusive task {} in execution service ", (Object)task.getId());
            this.taskExecutionService.runTask(task.getId());
        }
        catch (TaskExecutionException e) {
            log.error("An error occurred while trying to execute the task {}", (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            this.runningThread = false;
            this.readyToScan = false;
            Thread.currentThread().interrupt();
        }
    }

    private SearchResponse<TaskJson> getUnfinishedTasks(String cursor) {
        TaskSearchFilterJson taskSearchFilter = TaskSearchFilterJson.builder().status(TaskStatusEnum.PENDING, TaskStatusEnum.DELEGATED, TaskStatusEnum.READY_TO_EXECUTE, TaskStatusEnum.IN_PROGRESS).build();
        return (SearchResponse)this.transactionTemplate.execute(() -> this.taskDBService.searchTasks(50, cursor, taskSearchFilter, true));
    }

    private boolean belongsToCurrNode(TaskJson taskJson) {
        return this.clusterNodeInformation == null || this.clusterNodeInformation.getAnonymizedNodeIdentifier().equals(taskJson.getElectedNode());
    }

    private boolean taskIsNotRunning(int taskId) {
        return (Boolean)this.transactionTemplate.execute(() -> Objects.requireNonNull(this.taskDBService.getTask(taskId)).getStatus().equals((Object)TaskStatusEnum.IN_PROGRESS)) == false;
    }

    private boolean noTaskIsRunning() {
        return (Boolean)this.transactionTemplate.execute(() -> {
            SearchResponse<TaskJson> searchResponse = this.taskDBService.searchTasks(1, null, TaskSearchFilterJson.builder().status(TaskStatusEnum.IN_PROGRESS).build(), true);
            return searchResponse.getResults().isEmpty();
        });
    }
}

